/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clijx.imagej2;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clijx.imagej2.ImageJ2ServiceSingleton;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJx_imageJ2Tubeness")
public class ImageJ2Tubeness
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    public boolean executeCL() {
        return this.imageJ2Tubeness(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], ImageJ2Tubeness.asFloat((Object)this.args[2]), ImageJ2Tubeness.asFloat((Object)this.args[3]), ImageJ2Tubeness.asFloat((Object)this.args[4]), ImageJ2Tubeness.asFloat((Object)this.args[5]));
    }

    public boolean imageJ2Tubeness(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Float sigma, Float calibration_x, Float calibration_y, Float calibration_z) {
        ClearCLBuffer float_input = input;
        if (float_input.getNativeType() != NativeTypeEnum.Float) {
            float_input = clij2.create(input.getDimensions(), NativeTypeEnum.Float);
            clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)float_input);
        }
        RandomAccessibleInterval inputRAI = clij2.pullRAI((Object)float_input);
        if (float_input != input) {
            float_input.close();
        }
        Img outputRAI = input.getDimension() == 2L || input.getDepth() == 1L ? (Img)ImageJ2ServiceSingleton.getOpService().filter().tubeness(inputRAI, (double)sigma.floatValue(), new double[]{calibration_x.floatValue(), calibration_y.floatValue()}) : (Img)ImageJ2ServiceSingleton.getOpService().filter().tubeness(inputRAI, (double)sigma.floatValue(), new double[]{calibration_x.floatValue(), calibration_y.floatValue(), calibration_z.floatValue()});
        outputRAI = ImageJ2ServiceSingleton.getOpService().convert().float32(Views.iterable((RandomAccessibleInterval)outputRAI));
        ClearCLBuffer result = clij2.push((Object)outputRAI);
        clij2.copy((ClearCLImageInterface)result, (ClearCLImageInterface)output);
        result.close();
        return true;
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.getCLIJ2().create(input.getDimensions(), NativeTypeEnum.Float);
    }

    public String getDescription() {
        return "Apply ImageJ2 / ImageJ Ops Tubeness filter to an image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number sigma, Number calibrationX, Number calibrationY, Number calibrationZ";
    }

    public String getCategories() {
        return "Filter,Measurement";
    }

    public String getInputType() {
        return "Image";
    }

    public String getOutputType() {
        return "Image";
    }
}

