/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clijx.imagej2;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clijx.imagej2.ImageJ2ServiceSingleton;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJx_imageJ2RichardsonLucyDeconvolution")
public class ImageJ2RichardsonLucyDeconvolution
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    public String getParameterHelpText() {
        return "Image input, Image kernel_input, ByRef Image destination, Number num_iterations";
    }

    public boolean executeCL() {
        boolean result = ImageJ2RichardsonLucyDeconvolution.imageJ2RichardsonLucyDeconvolution(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], (ClearCLBuffer)this.args[2], ImageJ2RichardsonLucyDeconvolution.asInteger((Object)this.args[3]));
        return result;
    }

    public static boolean imageJ2RichardsonLucyDeconvolution(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer kernel_input, ClearCLBuffer output, Integer num_iterations) {
        ClearCLBuffer float_kernel_input;
        ClearCLBuffer float_input = input;
        if (float_input.getNativeType() != NativeTypeEnum.Float) {
            float_input = clij2.create(input.getDimensions(), NativeTypeEnum.Float);
            clij2.copy((ClearCLImageInterface)input, (ClearCLImageInterface)float_input);
        }
        RandomAccessibleInterval inputRAI = clij2.pullRAI((Object)float_input);
        RandomAccessibleInterval outputRAI = clij2.pullRAI((Object)float_input);
        if (float_input != input) {
            float_input.close();
        }
        if ((float_kernel_input = kernel_input).getNativeType() != NativeTypeEnum.Float) {
            float_kernel_input = clij2.create(input.getDimensions(), NativeTypeEnum.Float);
            clij2.copy((ClearCLImageInterface)kernel_input, (ClearCLImageInterface)float_kernel_input);
        }
        RandomAccessibleInterval kenrelInputRAI = clij2.pullRAI((Object)float_kernel_input);
        if (float_kernel_input != kernel_input) {
            float_kernel_input.close();
        }
        ImageJ2ServiceSingleton.getOpService().deconvolve().richardsonLucy(outputRAI, inputRAI, kenrelInputRAI, num_iterations.intValue());
        ClearCLBuffer result = clij2.push((Object)outputRAI);
        clij2.copy((ClearCLImageInterface)result, (ClearCLImageInterface)output);
        result.close();
        return true;
    }

    public String getDescription() {
        return "Apply ImageJ2 / ImageJ Ops Richardson Lucy Deconvolution to an image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Filter,Deconvolve";
    }

    public String getInputType() {
        return "Image";
    }

    public String getOutputType() {
        return "Image";
    }
}

