/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clijx.imagej2;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clijx.imagej2.ImageJ2ServiceSingleton;
import net.haesleinhuepf.clijx.imagej2.ImageJ2Utilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJx_imageJ2MedianSphere")
public class ImageJ2MedianSphere
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    public boolean executeCL() {
        return this.imageJ2MedianSphere(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], ImageJ2MedianSphere.asInteger((Object)this.args[2]));
    }

    public boolean imageJ2MedianSphere(CLIJ2 clij2, ClearCLBuffer input, ClearCLBuffer output, Integer radius) {
        RandomAccessibleInterval inputRAI = clij2.pullRAI((Object)input);
        RandomAccessibleInterval outputRAI = clij2.pullRAI((Object)input);
        ImageJ2ServiceSingleton.getOpService().filter().median(Views.iterable((RandomAccessibleInterval)outputRAI), inputRAI, ImageJ2Utilities.asSphere(radius.intValue()));
        ClearCLBuffer result = clij2.push((Object)outputRAI);
        clij2.copy((ClearCLImageInterface)result, (ClearCLImageInterface)output);
        result.close();
        return true;
    }

    public String getDescription() {
        return "Apply ImageJ2 / ImageJ Ops Median filter with a Sphere shape to an image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getParameterHelpText() {
        return "Image source, ByRef Image destination, Number radius";
    }

    public String getCategories() {
        return "Filter,Denoise";
    }

    public String getInputType() {
        return "Image";
    }

    public String getOutputType() {
        return "Image";
    }
}

