/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clijx.imagej2;

import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import net.haesleinhuepf.clijx.imagej2.ImageJ2ServiceSingleton;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJx_imageJ2GaussianBlur")
public class ImageJ2GaussianBlur
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    public String getParameterHelpText() {
        return "Image input, ByRef Image destination, Number sigma_x, Number sigma_y, Number sigma_z";
    }

    public boolean executeCL() {
        boolean result = ImageJ2GaussianBlur.imageJ2GaussianBlur(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1], ImageJ2GaussianBlur.asFloat((Object)this.args[2]), ImageJ2GaussianBlur.asFloat((Object)this.args[3]), ImageJ2GaussianBlur.asFloat((Object)this.args[4]));
        return result;
    }

    public static boolean imageJ2GaussianBlur(CLIJ2 clij2, ClearCLBuffer input1, ClearCLBuffer output, Float sigma_x, Float sigma_y, Float sigma_z) {
        RandomAccessibleInterval inputRAI = clij2.pullRAI((Object)input1);
        RandomAccessibleInterval outputRAI = ImageJ2ServiceSingleton.getOpService().filter().gauss(inputRAI, new double[]{sigma_x.floatValue(), sigma_y.floatValue(), sigma_z.floatValue()});
        ClearCLBuffer result = clij2.push((Object)outputRAI);
        clij2.copy((ClearCLImageInterface)result, (ClearCLImageInterface)output);
        result.close();
        return true;
    }

    public String getDescription() {
        return "Apply ImageJ2 / ImageJ Ops Gaussian Blur to an image.";
    }

    public String getAvailableForDimensions() {
        return "2D, 3D";
    }

    public String getCategories() {
        return "Filter,Denoise";
    }

    public String getInputType() {
        return "Image";
    }

    public String getOutputType() {
        return "Image";
    }
}

