/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.util.test;

import java.nio.ByteBuffer;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemory;
import net.haesleinhuepf.clij.coremem.util.Size;
import org.bridj.Pointer;
import org.junit.Assert;
import org.junit.Test;

public class SizeTests {
    @Test
    public void testPrimitives() {
        Assert.assertEquals((long)1L, (long)Size.of(Byte.class));
        Assert.assertEquals((long)2L, (long)Size.of(Short.class));
        Assert.assertEquals((long)2L, (long)Size.of(Character.class));
        Assert.assertEquals((long)4L, (long)Size.of(Integer.class));
        Assert.assertEquals((long)8L, (long)Size.of(Long.class));
        Assert.assertEquals((long)4L, (long)Size.of(Float.class));
        Assert.assertEquals((long)8L, (long)Size.of(Double.class));
        Assert.assertEquals((long)1L, (long)Size.of(Byte.TYPE));
        Assert.assertEquals((long)2L, (long)Size.of(Short.TYPE));
        Assert.assertEquals((long)2L, (long)Size.of(Character.TYPE));
        Assert.assertEquals((long)4L, (long)Size.of(Integer.TYPE));
        Assert.assertEquals((long)8L, (long)Size.of(Long.TYPE));
        Assert.assertEquals((long)4L, (long)Size.of(Float.TYPE));
        Assert.assertEquals((long)8L, (long)Size.of(Double.TYPE));
        byte b = 0;
        short s = 0;
        char c = '\u0000';
        int i = 0;
        long l = 0L;
        float f = 0.0f;
        double d = 0.0;
        Assert.assertEquals((long)1L, (long)Size.of((byte)b));
        Assert.assertEquals((long)2L, (long)Size.of((short)s));
        Assert.assertEquals((long)2L, (long)Size.of((char)c));
        Assert.assertEquals((long)4L, (long)Size.of((int)i));
        Assert.assertEquals((long)8L, (long)Size.of((long)l));
        Assert.assertEquals((long)4L, (long)Size.of((float)f));
        Assert.assertEquals((long)8L, (long)Size.of((double)d));
        Byte b2 = new Byte(0);
        Short s2 = new Short(0);
        Character c2 = new Character('\u0000');
        Integer i2 = new Integer(0);
        Long l2 = new Long(0L);
        Float f2 = new Float(0.0f);
        Double d2 = new Double(0.0);
        Assert.assertEquals((long)1L, (long)Size.of((Object)b2));
        Assert.assertEquals((long)2L, (long)Size.of((Object)s2));
        Assert.assertEquals((long)2L, (long)Size.of((Object)c2));
        Assert.assertEquals((long)4L, (long)Size.of((Object)i2));
        Assert.assertEquals((long)8L, (long)Size.of((Object)l2));
        Assert.assertEquals((long)4L, (long)Size.of((Object)f2));
        Assert.assertEquals((long)8L, (long)Size.of((Object)d2));
    }

    @Test
    public void testNativeTypeEnum() {
        Assert.assertEquals((long)Size.BYTE, (long)Size.of((Object)NativeTypeEnum.UnsignedByte));
        Assert.assertEquals((long)Size.BYTE, (long)Size.of((Object)NativeTypeEnum.Byte));
        Assert.assertEquals((long)Size.SHORT, (long)Size.of((Object)NativeTypeEnum.UnsignedShort));
        Assert.assertEquals((long)Size.SHORT, (long)Size.of((Object)NativeTypeEnum.Short));
        Assert.assertEquals((long)Size.INT, (long)Size.of((Object)NativeTypeEnum.UnsignedInt));
        Assert.assertEquals((long)Size.INT, (long)Size.of((Object)NativeTypeEnum.Int));
        Assert.assertEquals((long)Size.LONG, (long)Size.of((Object)NativeTypeEnum.Long));
        Assert.assertEquals((long)Size.HALFFLOAT, (long)Size.of((Object)NativeTypeEnum.HalfFloat));
        Assert.assertEquals((long)Size.FLOAT, (long)Size.of((Object)NativeTypeEnum.Float));
        Assert.assertEquals((long)Size.DOUBLE, (long)Size.of((Object)NativeTypeEnum.Double));
    }

    @Test
    public void testStrings() {
        Assert.assertEquals((long)0L, (long)Size.of((Object)""));
        Assert.assertEquals((long)(4 * Size.CHAR), (long)Size.of((Object)"1234"));
    }

    @Test
    public void testNIOBuffers() {
        Assert.assertEquals((long)11L, (long)Size.of((Object)ByteBuffer.allocateDirect(11)));
        Assert.assertEquals((long)22L, (long)Size.of((Object)ByteBuffer.allocateDirect(22).asCharBuffer()));
        Assert.assertEquals((long)22L, (long)Size.of((Object)ByteBuffer.allocateDirect(22).asShortBuffer()));
        Assert.assertEquals((long)44L, (long)Size.of((Object)ByteBuffer.allocateDirect(44).asIntBuffer()));
        Assert.assertEquals((long)88L, (long)Size.of((Object)ByteBuffer.allocateDirect(88).asLongBuffer()));
        Assert.assertEquals((long)44L, (long)Size.of((Object)ByteBuffer.allocateDirect(44).asFloatBuffer()));
        Assert.assertEquals((long)88L, (long)Size.of((Object)ByteBuffer.allocateDirect(88).asDoubleBuffer()));
    }

    @Test
    public void testOffHeapMemory() {
        OffHeapMemory lOffHeapMemory = OffHeapMemory.allocateBytes((long)11L);
        OffHeapMemory lContiguousMemoryInterface = OffHeapMemory.allocateBytes((long)11L);
        Assert.assertEquals((long)11L, (long)Size.of((Object)lOffHeapMemory));
        Assert.assertEquals((long)11L, (long)Size.of((Object)lContiguousMemoryInterface));
    }

    @Test
    public void testBridJPointer() {
        Pointer lPointer = Pointer.allocateBytes((long)11L);
        Assert.assertEquals((long)11L, (long)Size.of((Object)lPointer));
    }
}

