/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.test;

import net.haesleinhuepf.clij.coremem.ContiguousMemoryInterface;
import net.haesleinhuepf.clij.coremem.enums.MemoryType;
import net.haesleinhuepf.clij.coremem.interfaces.Copyable;
import net.haesleinhuepf.clij.coremem.interfaces.MappableMemory;
import net.haesleinhuepf.clij.coremem.interfaces.RangeCopyable;
import net.haesleinhuepf.clij.coremem.interfaces.Resizable;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemoryAccess;
import org.junit.Assert;

public class ContiguousMemoryTestsHelper {
    public static void testBasics(ContiguousMemoryInterface pContiguousMemoryInterface, MemoryType pMemoryType, boolean pResize) {
        long lLength = pContiguousMemoryInterface.getSizeInBytes();
        if (pContiguousMemoryInterface instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface).map();
        }
        Assert.assertTrue((pContiguousMemoryInterface.getAddress() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((pContiguousMemoryInterface.getMemoryType() == pMemoryType ? 1 : 0) != 0);
        Assert.assertFalse((boolean)pContiguousMemoryInterface.isFree());
        if (pResize) {
            if (pContiguousMemoryInterface instanceof Resizable) {
                ((Resizable)pContiguousMemoryInterface).resize(lLength / 2L);
            }
            Assert.assertTrue((pContiguousMemoryInterface.getSizeInBytes() == lLength / 2L ? 1 : 0) != 0);
            if (pContiguousMemoryInterface instanceof Resizable) {
                ((Resizable)pContiguousMemoryInterface).resize(lLength);
            }
            Assert.assertTrue((pContiguousMemoryInterface.getSizeInBytes() == lLength ? 1 : 0) != 0);
        }
        if (pContiguousMemoryInterface instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface).unmap();
        }
        pContiguousMemoryInterface.free();
    }

    public static void testCopySameSize(ContiguousMemoryInterface pContiguousMemoryInterface1, ContiguousMemoryInterface pContiguousMemoryInterface2) {
        if (pContiguousMemoryInterface1 instanceof Copyable) {
            if (pContiguousMemoryInterface1 instanceof MappableMemory) {
                ((MappableMemory)pContiguousMemoryInterface1).map();
            }
            if (pContiguousMemoryInterface2 instanceof MappableMemory) {
                ((MappableMemory)pContiguousMemoryInterface2).map();
            }
            OffHeapMemoryAccess.setByte((long)pContiguousMemoryInterface1.getAddress(), (byte)123);
            OffHeapMemoryAccess.setByte((long)(pContiguousMemoryInterface1.getAddress() + pContiguousMemoryInterface1.getSizeInBytes() / 2L), (byte)-56);
            pContiguousMemoryInterface1.copyTo((Copyable)pContiguousMemoryInterface2);
            Assert.assertEquals((long)123L, (long)OffHeapMemoryAccess.getByte((long)pContiguousMemoryInterface2.getAddress()));
            Assert.assertEquals((long)-56L, (long)OffHeapMemoryAccess.getByte((long)(pContiguousMemoryInterface2.getAddress() + pContiguousMemoryInterface1.getSizeInBytes() / 2L)));
            pContiguousMemoryInterface1.free();
            pContiguousMemoryInterface2.free();
            try {
                pContiguousMemoryInterface1.copyTo((Copyable)pContiguousMemoryInterface2);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (pContiguousMemoryInterface1 instanceof MappableMemory) {
                ((MappableMemory)pContiguousMemoryInterface1).unmap();
            }
            if (pContiguousMemoryInterface2 instanceof MappableMemory) {
                ((MappableMemory)pContiguousMemoryInterface2).unmap();
            }
        }
    }

    public static void testCopyRange(ContiguousMemoryInterface pContiguousMemoryInterface1, ContiguousMemoryInterface pContiguousMemoryInterface2) {
        if (pContiguousMemoryInterface1 instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface1).map();
        }
        if (pContiguousMemoryInterface2 instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface2).map();
        }
        OffHeapMemoryAccess.setByte((long)(pContiguousMemoryInterface1.getAddress() + 2L), (byte)123);
        OffHeapMemoryAccess.setByte((long)(pContiguousMemoryInterface1.getAddress() + 3L), (byte)111);
        if (pContiguousMemoryInterface1 instanceof Copyable) {
            ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface2, 4L, 2L);
            Assert.assertEquals((long)123L, (long)OffHeapMemoryAccess.getByte((long)(pContiguousMemoryInterface2.getAddress() + 4L)));
            Assert.assertEquals((long)111L, (long)OffHeapMemoryAccess.getByte((long)(pContiguousMemoryInterface2.getAddress() + 5L)));
            pContiguousMemoryInterface1.free();
            pContiguousMemoryInterface2.free();
            try {
                ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface2, 4L, 2L);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (pContiguousMemoryInterface1 instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface1).unmap();
        }
        if (pContiguousMemoryInterface2 instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface2).unmap();
        }
    }

    public static void testCopyChecks(ContiguousMemoryInterface pContiguousMemoryInterface1, ContiguousMemoryInterface pContiguousMemoryInterface2) {
        if (pContiguousMemoryInterface1 instanceof Copyable) {
            try {
                ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface2, 4L, 3L);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface2, 4L, -2L);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface1, 4L, 9L);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            pContiguousMemoryInterface1.free();
            pContiguousMemoryInterface2.free();
            try {
                ((RangeCopyable)pContiguousMemoryInterface1).copyRangeTo(2L, (Object)pContiguousMemoryInterface2, 4L, 2L);
                Assert.fail();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void testWriteRead(ContiguousMemoryInterface pContiguousMemoryInterface) {
        if (pContiguousMemoryInterface instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface).map();
        }
        pContiguousMemoryInterface.setByteAligned(0L, (byte)-1);
        pContiguousMemoryInterface.setByteAligned(1L, (byte)-1);
        pContiguousMemoryInterface.setByteAligned(2L, (byte)-1);
        pContiguousMemoryInterface.setByteAligned(3L, (byte)-1);
        Assert.assertEquals((long)65535L, (long)pContiguousMemoryInterface.getCharAligned(0L));
        Assert.assertEquals((long)-1L, (long)pContiguousMemoryInterface.getShortAligned(0L));
        Assert.assertEquals((long)-1L, (long)pContiguousMemoryInterface.getIntAligned(0L));
        Assert.assertEquals((double)Double.NaN, (double)pContiguousMemoryInterface.getFloatAligned(0L), (double)0.0);
        if (pContiguousMemoryInterface instanceof MappableMemory) {
            ((MappableMemory)pContiguousMemoryInterface).unmap();
        }
    }
}

