/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.rgc.test;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.haesleinhuepf.clij.coremem.rgc.Cleanable;
import net.haesleinhuepf.clij.coremem.rgc.Cleaner;
import net.haesleinhuepf.clij.coremem.rgc.Freeable;
import net.haesleinhuepf.clij.coremem.rgc.FreeableBase;
import net.haesleinhuepf.clij.coremem.rgc.RessourceCleaner;
import org.junit.Assert;
import org.junit.Test;

public class RessourceGarbageCollectorTests {
    static AtomicInteger sCounter = new AtomicInteger(0);

    public static final void freeRessource(long pResourceId) {
        sCounter.incrementAndGet();
    }

    @Test
    public void testRessourceCleaner() throws InterruptedException {
        int i;
        int N = 100;
        for (i = 0; i < N; ++i) {
            ClassWithRessource a = new ClassWithRessource();
            this.sleep(1);
        }
        for (i = 0; i < 10000 || RessourceCleaner.getNumberOfRegisteredObjects() != 0; ++i) {
            this.sleep(1);
            if (i % 100 != 0) continue;
            System.gc();
        }
        int lNumberOfRegisteredObjects = RessourceCleaner.getNumberOfRegisteredObjects();
        Assert.assertEquals((long)0L, (long)lNumberOfRegisteredObjects);
        Assert.assertEquals((long)N, (long)sCounter.get());
    }

    private void sleep(int pMilliseconds) {
        try {
            Thread.sleep(pMilliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class ClassWithRessource
    extends FreeableBase
    implements Freeable,
    Cleanable {
        long mSomeRessource = (long)(1000.0 * Math.random());
        AtomicBoolean mFree = new AtomicBoolean(false);

        private ClassWithRessource() {
            ClassWithRessource lClassWithRessource = this;
            RessourceCleaner.register((Cleanable)lClassWithRessource);
        }

        public Cleaner getCleaner() {
            return new MyCleaner(this.mSomeRessource);
        }

        public void free() {
            this.mFree.set(false);
            RessourceGarbageCollectorTests.freeRessource(this.mSomeRessource);
        }

        public boolean isFree() {
            return this.mFree.get();
        }

        static class MyCleaner
        implements Cleaner {
            private long mSomeRessource2;

            public MyCleaner(long pSomeRessource) {
                this.mSomeRessource2 = pSomeRessource;
            }

            public void run() {
                RessourceGarbageCollectorTests.freeRessource(this.mSomeRessource2);
            }
        }
    }
}

