/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.recycling.test;

import java.util.concurrent.atomic.AtomicBoolean;
import net.haesleinhuepf.clij.coremem.ContiguousMemoryInterface;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemory;
import net.haesleinhuepf.clij.coremem.recycling.RecyclableInterface;
import net.haesleinhuepf.clij.coremem.recycling.RecyclerInterface;
import net.haesleinhuepf.clij.coremem.recycling.test.TestRequest;
import net.haesleinhuepf.clij.coremem.rgc.FreeableBase;

public class TestRecyclable
extends FreeableBase
implements RecyclableInterface<TestRecyclable, TestRequest> {
    ContiguousMemoryInterface mBuffer;
    private RecyclerInterface<TestRecyclable, TestRequest> mRecycler;
    AtomicBoolean mReleased = new AtomicBoolean(false);

    public TestRecyclable(TestRequest pRequest) {
        this.recycle(pRequest);
    }

    public long getSizeInBytes() {
        return this.mBuffer.getSizeInBytes();
    }

    public void free() {
        this.mBuffer.free();
    }

    public boolean isFree() {
        return this.mBuffer.isFree();
    }

    public boolean isCompatible(TestRequest pRequest) {
        return this.mBuffer.getSizeInBytes() == pRequest.size;
    }

    public void recycle(TestRequest pRequest) {
        this.mBuffer = OffHeapMemory.allocateBytes((long)pRequest.size);
    }

    public void setReleased(boolean pIsReleased) {
        this.mReleased.set(pIsReleased);
    }

    public boolean isReleased() {
        return this.mReleased.get();
    }

    public void release() {
        this.mRecycler.release((RecyclableInterface)this);
    }

    public void setRecycler(RecyclerInterface<TestRecyclable, TestRequest> pRecycler) {
        this.mRecycler = pRecycler;
    }

    public String toString() {
        return String.format("TestRecyclable [mBuffer=%s, mRecycler=%s, mReleased=%s]", this.mBuffer, this.mRecycler, this.mReleased);
    }
}

