/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.recycling.test;

import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.haesleinhuepf.clij.coremem.recycling.BasicRecycler;
import net.haesleinhuepf.clij.coremem.recycling.RecyclableFactoryInterface;
import net.haesleinhuepf.clij.coremem.recycling.RecyclableInterface;
import net.haesleinhuepf.clij.coremem.recycling.RecyclerRequestInterface;
import net.haesleinhuepf.clij.coremem.recycling.test.TestRecyclable;
import net.haesleinhuepf.clij.coremem.recycling.test.TestRequest;
import org.junit.Assert;
import org.junit.Test;

public class RecyclerTests {
    @Test
    public void testBasics() {
        TestRecyclable lFailOrRequestRecyclableObject;
        int i;
        int i2;
        RecyclableFactoryInterface<TestRecyclable, TestRequest> lRecyclableFactory = new RecyclableFactoryInterface<TestRecyclable, TestRequest>(){

            public TestRecyclable create(TestRequest pParameters) {
                return new TestRecyclable(pParameters);
            }
        };
        BasicRecycler lRecycler = new BasicRecycler((RecyclableFactoryInterface)lRecyclableFactory, 200, 200, true);
        Assert.assertEquals((long)100L, (long)lRecycler.ensurePreallocated(100L, (RecyclerRequestInterface)new TestRequest(1L)));
        Assert.assertEquals((long)100L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        lRecycler.clearReleased();
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        Assert.assertEquals((long)100L, (long)lRecycler.ensurePreallocated(100L, (RecyclerRequestInterface)new TestRequest(1L)));
        Assert.assertEquals((long)100L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        HashSet<TestRecyclable> lRecyclableObjectSet = new HashSet<TestRecyclable>();
        for (i2 = 0; i2 < 200; ++i2) {
            TestRecyclable lRecyclableObject = (TestRecyclable)lRecycler.getOrFail((RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            lRecyclableObjectSet.add(lRecyclableObject);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            TestRecyclable lFailOrRequestRecyclableObject2 = (TestRecyclable)lRecycler.getOrFail((RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lFailOrRequestRecyclableObject2 == null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfLiveObjects());
        long lStartTimeNs = System.nanoTime();
        for (int i3 = 0; i3 < 10; ++i3) {
            TestRecyclable lFailOrRequestRecyclableObject3 = (TestRecyclable)lRecycler.getOrWait(100L, TimeUnit.MILLISECONDS, (RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lFailOrRequestRecyclableObject3 == null ? 1 : 0) != 0);
        }
        long lStopTimeNs = System.nanoTime();
        Assert.assertTrue((1.0E9 < (double)(lStopTimeNs - lStartTimeNs) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfLiveObjects());
        for (TestRecyclable lTestRecyclable : lRecyclableObjectSet) {
            lRecycler.release((RecyclableInterface)lTestRecyclable);
        }
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        lRecycler.clearReleased();
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        for (i = 0; i < 100; ++i) {
            lFailOrRequestRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.MICROSECONDS, (RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lFailOrRequestRecyclableObject != null ? 1 : 0) != 0);
            lRecycler.release((RecyclableInterface)lFailOrRequestRecyclableObject);
        }
        Assert.assertEquals((long)1L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        for (i = 0; i < 200; ++i) {
            TestRecyclable lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.MICROSECONDS, (RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            lRecyclableObjectSet.add(lRecyclableObject);
        }
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfLiveObjects());
        for (i = 0; i < 10; ++i) {
            lFailOrRequestRecyclableObject = (TestRecyclable)lRecycler.getOrFail((RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lFailOrRequestRecyclableObject == null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfLiveObjects());
        lRecycler.free();
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)200L, (long)lRecycler.getNumberOfLiveObjects());
    }

    @Test
    public void testTightRecycling() {
        RecyclableFactoryInterface<TestRecyclable, TestRequest> lRecyclableFactory = new RecyclableFactoryInterface<TestRecyclable, TestRequest>(){

            public TestRecyclable create(TestRequest pParameters) {
                return new TestRecyclable(pParameters);
            }
        };
        BasicRecycler lRecycler = new BasicRecycler((RecyclableFactoryInterface)lRecyclableFactory, 1000);
        for (int i = 0; i < 100000; ++i) {
            TestRecyclable lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(1L));
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            lRecycler.release((RecyclableInterface)lRecyclableObject);
        }
    }

    @Test
    public void testTightRecyclingWithRequestChanges() {
        TestRecyclable lRecyclableObject;
        int i;
        RecyclableFactoryInterface<TestRecyclable, TestRequest> lRecyclableFactory = new RecyclableFactoryInterface<TestRecyclable, TestRequest>(){

            public TestRecyclable create(TestRequest pParameters) {
                return new TestRecyclable(pParameters);
            }
        };
        BasicRecycler lRecycler = new BasicRecycler((RecyclableFactoryInterface)lRecyclableFactory, 10, 10, true);
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        for (i = 0; i < 10; ++i) {
            lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(1024L));
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            Assert.assertEquals((long)1024L, (long)lRecyclableObject.getSizeInBytes());
            lRecycler.release((RecyclableInterface)lRecyclableObject);
        }
        Assert.assertEquals((long)1L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
        for (i = 0; i < 10; ++i) {
            lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(2048L));
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            Assert.assertEquals((long)2048L, (long)lRecyclableObject.getSizeInBytes());
        }
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfAvailableObjects());
        Assert.assertEquals((long)10L, (long)lRecycler.getNumberOfLiveObjects());
        Assert.assertEquals(null, (Object)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(2048L)));
        lRecycler.clearLive();
        for (i = 0; i < 100000; ++i) {
            if (i % 100 == 0) {
                lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(1024L));
                Assert.assertEquals((long)1024L, (long)lRecyclableObject.getSizeInBytes());
            } else {
                lRecyclableObject = (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(2048L));
                Assert.assertEquals((long)2048L, (long)lRecyclableObject.getSizeInBytes());
            }
            Assert.assertTrue((lRecyclableObject != null ? 1 : 0) != 0);
            lRecycler.release((RecyclableInterface)lRecyclableObject);
        }
    }

    @Test
    public void testAsynchronousRecyclingWithRequestChanges() throws InterruptedException {
        RecyclableFactoryInterface<TestRecyclable, TestRequest> lRecyclableFactory = new RecyclableFactoryInterface<TestRecyclable, TestRequest>(){

            public TestRecyclable create(TestRequest pParameters) {
                return new TestRecyclable(pParameters);
            }
        };
        final BasicRecycler lRecycler = new BasicRecycler((RecyclableFactoryInterface)lRecyclableFactory, 10, 10, true);
        final ArrayBlockingQueue lQueue = new ArrayBlockingQueue(10);
        Runnable lRunnableProducer = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    TestRecyclable lRecyclable = i % 10 == 0 ? (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(1024L)) : (TestRecyclable)lRecycler.getOrWait(1L, TimeUnit.SECONDS, (RecyclerRequestInterface)new TestRequest(2048L));
                    lQueue.offer(lRecyclable);
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        Runnable lRunnableConsumer = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    try {
                        TestRecyclable lRecyclable = (TestRecyclable)((Object)lQueue.take());
                        if (lRecyclable == null) continue;
                        try {
                            Thread.sleep(3L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        lRecyclable.release();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        ExecutorService lProducerExecutor = Executors.newSingleThreadExecutor();
        ExecutorService lConsumerExecutor = Executors.newSingleThreadExecutor();
        lConsumerExecutor.execute(lRunnableConsumer);
        lProducerExecutor.execute(lRunnableProducer);
        lConsumerExecutor.shutdown();
        lConsumerExecutor.awaitTermination(100L, TimeUnit.SECONDS);
        lProducerExecutor.shutdown();
        lProducerExecutor.awaitTermination(100L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)lRecycler.getNumberOfLiveObjects());
    }
}

