/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.offheap.test;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import net.haesleinhuepf.clij.coremem.ContiguousMemoryInterface;
import net.haesleinhuepf.clij.coremem.enums.MemoryType;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemory;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemoryAccess;
import net.haesleinhuepf.clij.coremem.rgc.RessourceCleaner;
import net.haesleinhuepf.clij.coremem.test.ContiguousMemoryTestsHelper;
import org.junit.Assert;
import org.junit.Test;

public class OffHeapMemoryTests {
    @Test
    public void testBasics() {
        OffHeapMemory lOffHeapMemory = new OffHeapMemory(0xFFFFFFFEL);
        ContiguousMemoryTestsHelper.testBasics((ContiguousMemoryInterface)lOffHeapMemory, MemoryType.CPURAMDIRECT, true);
    }

    @Test
    public void testRessourceCleaning() throws InterruptedException {
        int i;
        RessourceCleaner.cleanNow();
        long lInitialNumberOfRegisteredObjects = RessourceCleaner.getNumberOfRegisteredObjects();
        long lInitialAllocatedMemory = OffHeapMemoryAccess.getTotalAllocatedMemory();
        for (i = 0; i < 100; ++i) {
            OffHeapMemory lOffHeapMemory = new OffHeapMemory(1024L);
            lOffHeapMemory.setByte((long)i % lOffHeapMemory.getSizeInBytes(), (byte)i);
            System.gc();
            Thread.sleep(1L);
        }
        for (i = 0; i < 1000; ++i) {
            System.gc();
            Thread.sleep(1L);
            if (OffHeapMemoryAccess.getTotalAllocatedMemory() == 0L && OffHeapMemoryAccess.getTotalAllocatedMemory() == 0L) break;
        }
        Assert.assertTrue(((long)RessourceCleaner.getNumberOfRegisteredObjects() <= lInitialNumberOfRegisteredObjects ? 1 : 0) != 0);
        Assert.assertTrue((OffHeapMemoryAccess.getTotalAllocatedMemory() <= lInitialAllocatedMemory ? 1 : 0) != 0);
    }

    @Test
    public void testCopySameSize() {
        OffHeapMemory lOffHeapMemory1 = new OffHeapMemory(Integer.MAX_VALUE);
        OffHeapMemory lOffHeapMemory2 = new OffHeapMemory(Integer.MAX_VALUE);
        ContiguousMemoryTestsHelper.testCopySameSize((ContiguousMemoryInterface)lOffHeapMemory1, (ContiguousMemoryInterface)lOffHeapMemory2);
    }

    @Test
    public void testCopyDifferentSize() {
        OffHeapMemory lOffHeapMemory1 = new OffHeapMemory(4L);
        OffHeapMemory lOffHeapMemory2 = new OffHeapMemory(8L);
        ContiguousMemoryTestsHelper.testCopyRange((ContiguousMemoryInterface)lOffHeapMemory1, (ContiguousMemoryInterface)lOffHeapMemory2);
    }

    @Test
    public void testCopyChecks() {
        OffHeapMemory lOffHeapMemory1 = new OffHeapMemory(4L);
        OffHeapMemory lOffHeapMemory2 = new OffHeapMemory(8L);
        ContiguousMemoryTestsHelper.testCopyChecks((ContiguousMemoryInterface)lOffHeapMemory1, (ContiguousMemoryInterface)lOffHeapMemory2);
    }

    @Test
    public void testWriteRead() {
        OffHeapMemory lOffHeapMemory = new OffHeapMemory(4L);
        ContiguousMemoryTestsHelper.testWriteRead((ContiguousMemoryInterface)lOffHeapMemory);
    }

    @Test
    public void testWriteToReadFromFileChannel() throws IOException {
        File lTempFile = File.createTempFile(this.getClass().getSimpleName(), "testWriteToReadFromFileChannel");
        lTempFile.delete();
        FileChannel lFileChannel1 = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        OffHeapMemory lOffHeapMemory1 = new OffHeapMemory(1023L);
        int i = 0;
        while ((long)i < lOffHeapMemory1.getSizeInBytes()) {
            lOffHeapMemory1.setByte((long)i, (byte)i);
            ++i;
        }
        lOffHeapMemory1.writeBytesToFileChannel(lFileChannel1, 512L);
        lOffHeapMemory1.free();
        lFileChannel1.close();
        Assert.assertTrue((boolean)lTempFile.exists());
        Assert.assertEquals((long)1535L, (long)lTempFile.length());
        FileChannel lFileChannel2 = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Assert.assertEquals((long)1535L, (long)lFileChannel2.size());
        OffHeapMemory lOffHeapMemory2 = new OffHeapMemory(1023L);
        lOffHeapMemory2.readBytesFromFileChannel(lFileChannel2, 512L, lOffHeapMemory2.getSizeInBytes());
        int i2 = 0;
        while ((long)i2 < lOffHeapMemory2.getSizeInBytes()) {
            Assert.assertEquals((long)((byte)i2), (long)lOffHeapMemory2.getByte((long)i2));
            ++i2;
        }
        lOffHeapMemory2.free();
        lFileChannel2.close();
    }
}

