/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.offheap.test;

import net.haesleinhuepf.clij.coremem.exceptions.InvalidNativeMemoryAccessException;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemoryAccess;
import org.junit.Assert;
import org.junit.Test;

public class OffHeapMemoryAccessTests {
    private static final long cBufferSize = 0xFFFFFFFEL;

    @Test
    public void testMaxAllocation() {
        try {
            int i;
            try {
                OffHeapMemoryAccess.freeAll();
                OffHeapMemoryAccess.setMaximumAllocatableMemory((long)1000000L);
                for (i = 0; i < 2000; ++i) {
                    OffHeapMemoryAccess.allocateMemory((long)1000L);
                }
                Assert.fail();
            }
            catch (OutOfMemoryError e) {
                Assert.assertTrue((i >= 1000 ? 1 : 0) != 0);
            }
            catch (Throwable lE) {
                Assert.fail();
            }
            OffHeapMemoryAccess.freeAll();
            Assert.assertEquals((long)0L, (long)OffHeapMemoryAccess.getTotalAllocatedMemory());
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            OffHeapMemoryAccess.setMaximumAllocatableMemory((long)Long.MAX_VALUE);
        }
    }

    @Test
    public void testAllocateReallocateFree() {
        try {
            long lAddress = OffHeapMemoryAccess.allocateMemory((long)0xFFFFFFFEL);
            OffHeapMemoryAccess.setByte((long)lAddress, (byte)123);
            Assert.assertEquals((long)OffHeapMemoryAccess.getByte((long)lAddress), (long)123L);
            long lAddressReallocated = OffHeapMemoryAccess.reallocateMemory((long)lAddress, (long)10L);
            OffHeapMemoryAccess.setByte((long)(lAddressReallocated + 9L), (byte)123);
            Assert.assertEquals((long)OffHeapMemoryAccess.getByte((long)(lAddressReallocated + 9L)), (long)123L);
            OffHeapMemoryAccess.freeMemory((long)lAddressReallocated);
        }
        catch (InvalidNativeMemoryAccessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSuperBig() {
        try {
            long i;
            long lLength = 1000000000L;
            long lAddress = OffHeapMemoryAccess.allocateMemory((long)1000000000L);
            Assert.assertFalse((lAddress == 0L ? 1 : 0) != 0);
            OffHeapMemoryAccess.fillMemory((long)lAddress, (long)1000000000L, (byte)0);
            for (i = 0L; i < 1000000000L; i += 1000000L) {
                OffHeapMemoryAccess.setByte((long)(lAddress + i), (byte)((byte)i));
            }
            for (i = 0L; i < 1000000000L; i += 1000000L) {
                byte lValue = OffHeapMemoryAccess.getByte((long)(lAddress + i));
                Assert.assertEquals((long)((byte)i), (long)lValue);
            }
            OffHeapMemoryAccess.freeMemory((long)lAddress);
        }
        catch (InvalidNativeMemoryAccessException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

