/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.memmap.test;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import net.haesleinhuepf.clij.coremem.memmap.MemoryMappedFile;
import net.haesleinhuepf.clij.coremem.memmap.MemoryMappedFileAccessMode;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemoryAccess;
import org.junit.Assert;
import org.junit.Test;

public class MemoryMappedFileTest {
    @Test
    public void testMapLargeFile() throws IOException, InterruptedException {
        File lTempFile = File.createTempFile("MemoryMappedFileTest", "test1");
        lTempFile.deleteOnExit();
        FileChannel lFileChannel = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        long lMappingLength = 2147484639L;
        MemoryMappedFile lMemoryMappedFile = new MemoryMappedFile(lFileChannel, MemoryMappedFileAccessMode.ReadWrite, 0L, lMappingLength, true);
        long lBaseAddress = lMemoryMappedFile.getAddressAtFilePosition(0L);
        for (long i = 0L; i < lMappingLength; ++i) {
            OffHeapMemoryAccess.setByte((long)(lBaseAddress + i), (byte)123);
        }
        Assert.assertEquals((long)123L, (long)OffHeapMemoryAccess.getByte((long)lBaseAddress));
        Assert.assertEquals((long)123L, (long)OffHeapMemoryAccess.getByte((long)(lBaseAddress + lMappingLength - 1L)));
        lMemoryMappedFile.close();
        lFileChannel.close();
    }

    @Test
    public void testMapNotFromStart() throws IOException, InterruptedException {
        File lTempFile = File.createTempFile("MemoryMappedFileTest", "test1");
        lTempFile.deleteOnExit();
        FileChannel lFileChannel = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        long lMappingOffset = 234567L;
        long lMappingLength = 123456L;
        MemoryMappedFile lMemoryMappedFile = new MemoryMappedFile(lFileChannel, MemoryMappedFileAccessMode.ReadWrite, lMappingOffset, lMappingLength, true);
        long lBaseAddress = lMemoryMappedFile.getAddressAtFilePosition(lMappingOffset);
        for (long i = 0L; i < lMappingLength; ++i) {
            OffHeapMemoryAccess.setByte((long)(lBaseAddress + i), (byte)((byte)i));
        }
        Assert.assertEquals((long)0L, (long)OffHeapMemoryAccess.getByte((long)lBaseAddress));
        Assert.assertEquals((long)((byte)(lMappingLength - 1L)), (long)OffHeapMemoryAccess.getByte((long)(lBaseAddress + lMappingLength - 1L)));
        lMemoryMappedFile.close();
        lFileChannel.close();
    }

    @Test
    public void testCreateFileAndOpenInTheMiddle() throws IOException, InterruptedException {
        File lTempFile = File.createTempFile("MemoryMappedFileTest", "test1");
        lTempFile.deleteOnExit();
        FileChannel lFileChannel = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        long lFileLength = 123456L;
        MemoryMappedFile lMemoryMappedFile = new MemoryMappedFile(lFileChannel, MemoryMappedFileAccessMode.ReadWrite, 0L, lFileLength, true);
        long lBaseAddress = lMemoryMappedFile.getAddressAtFilePosition(0L);
        for (long i = 0L; i < lFileLength; ++i) {
            OffHeapMemoryAccess.setByte((long)(lBaseAddress + i), (byte)((byte)i));
        }
        Assert.assertEquals((long)0L, (long)OffHeapMemoryAccess.getByte((long)lBaseAddress));
        Assert.assertEquals((long)((byte)(lFileLength - 1L)), (long)OffHeapMemoryAccess.getByte((long)(lBaseAddress + lFileLength - 1L)));
        lMemoryMappedFile.close();
        lFileChannel.close();
        lFileChannel = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        long lMappingOffset = 23456L;
        long lMappingLength = 66456L;
        MemoryMappedFile lMemoryMappedFile2 = new MemoryMappedFile(lFileChannel, MemoryMappedFileAccessMode.ReadWrite, lMappingOffset, lMappingLength, true);
        long lBaseAddress2 = lMemoryMappedFile2.getAddressAtFilePosition(23456L);
        for (long i = 0L; i < lMappingLength; ++i) {
            Assert.assertEquals((long)((byte)(lMappingOffset + i)), (long)OffHeapMemoryAccess.getByte((long)(lBaseAddress2 + i)));
        }
        lMemoryMappedFile2.close();
        lFileChannel.close();
    }
}

