/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.memmap.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import net.haesleinhuepf.clij.coremem.ContiguousMemoryInterface;
import net.haesleinhuepf.clij.coremem.enums.MemoryType;
import net.haesleinhuepf.clij.coremem.memmap.FileMappedMemoryRegion;
import net.haesleinhuepf.clij.coremem.test.ContiguousMemoryTestsHelper;
import org.junit.Test;

public class FileMappedMemoryRegionTests {
    private static final long cMemoryRegionSize = 1024L;

    @Test
    public void testLargeMemory() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface = new FileMappedMemoryRegion(this.createTempFile(), 1000L, 0x8CCCCCCBL, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testBasics((ContiguousMemoryInterface)lContiguousMemoryInterface, MemoryType.FILERAM, false);
    }

    @Test
    public void testBasics() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface = new FileMappedMemoryRegion(this.createTempFile(), 1000L, 1024L, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testBasics((ContiguousMemoryInterface)lContiguousMemoryInterface, MemoryType.FILERAM, false);
    }

    private File createTempFile() throws IOException {
        File lCreateTempFile = File.createTempFile(FileMappedMemoryRegionTests.class.toString(), "" + Math.random());
        lCreateTempFile.deleteOnExit();
        return lCreateTempFile;
    }

    @Test
    public void testCopySameSize() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface1 = new FileMappedMemoryRegion(this.createTempFile(), 1000L, 1024L, new StandardOpenOption[0]);
        FileMappedMemoryRegion lContiguousMemoryInterface2 = new FileMappedMemoryRegion(this.createTempFile(), 1000L, 1024L, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testCopySameSize((ContiguousMemoryInterface)lContiguousMemoryInterface1, (ContiguousMemoryInterface)lContiguousMemoryInterface2);
    }

    @Test
    public void testCopyDifferentSize() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface1 = new FileMappedMemoryRegion(this.createTempFile(), 1L, 4L, new StandardOpenOption[0]);
        FileMappedMemoryRegion lContiguousMemoryInterface2 = new FileMappedMemoryRegion(this.createTempFile(), 1L, 8L, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testCopyRange((ContiguousMemoryInterface)lContiguousMemoryInterface1, (ContiguousMemoryInterface)lContiguousMemoryInterface2);
    }

    @Test
    public void testCopyChecks() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface1 = new FileMappedMemoryRegion(this.createTempFile(), 1L, 4L, new StandardOpenOption[0]);
        FileMappedMemoryRegion lContiguousMemoryInterface2 = new FileMappedMemoryRegion(this.createTempFile(), 1L, 8L, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testCopyChecks((ContiguousMemoryInterface)lContiguousMemoryInterface1, (ContiguousMemoryInterface)lContiguousMemoryInterface2);
    }

    @Test
    public void testWriteRead() throws IOException {
        FileMappedMemoryRegion lContiguousMemoryInterface = new FileMappedMemoryRegion(this.createTempFile(), 1L, 4L, new StandardOpenOption[0]);
        ContiguousMemoryTestsHelper.testWriteRead((ContiguousMemoryInterface)lContiguousMemoryInterface);
    }
}

