/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.interop.test;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.haesleinhuepf.clij.coremem.interop.NIOBuffersInterop;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemory;
import org.junit.Assert;
import org.junit.Test;

public class NIOBuffersInteropTests {
    private static final int cBufferLength = 32;

    @Test
    public void testByteBuffer() {
        ByteBuffer lBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder());
        OffHeapMemory lContiguousMemory = NIOBuffersInterop.getContiguousMemoryFrom((Buffer)lBuffer);
        Assert.assertTrue((lContiguousMemory.getAddress() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)32L, (long)lContiguousMemory.getSizeInBytes());
        lBuffer.putInt(15, 12345);
        Assert.assertEquals((long)12345L, (long)lContiguousMemory.getInt(15L));
    }

    @Test
    public void testDoubleBuffer() {
        DoubleBuffer lBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        OffHeapMemory lContiguousMemory = NIOBuffersInterop.getContiguousMemoryFrom((Buffer)lBuffer);
        Assert.assertTrue((lContiguousMemory.getAddress() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)32L, (long)lContiguousMemory.getSizeInBytes());
        lBuffer.put(3, 12345.54321);
        Assert.assertEquals((double)12345.54321, (double)lContiguousMemory.getDoubleAligned(3L), (double)0.001);
    }
}

