/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.fragmented.tests;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import net.haesleinhuepf.clij.coremem.ContiguousMemoryInterface;
import net.haesleinhuepf.clij.coremem.fragmented.FragmentedMemory;
import net.haesleinhuepf.clij.coremem.offheap.OffHeapMemory;
import org.junit.Assert;
import org.junit.Test;

public class FragmentedMemoryTests {
    @Test
    public void testWriteToReadFromFileChannel() throws IOException {
        int i;
        File lTempFile = File.createTempFile(this.getClass().getSimpleName(), "testWriteToReadFromFileChannel");
        lTempFile.delete();
        lTempFile.deleteOnExit();
        FileChannel lFileChannel1 = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        FragmentedMemory lFragmentedMemory1 = new FragmentedMemory();
        for (int i2 = 0; i2 < 100; ++i2) {
            OffHeapMemory lOffHeapMemory = new OffHeapMemory(129L);
            int j = 0;
            while ((long)j < lOffHeapMemory.getSizeInBytes()) {
                lOffHeapMemory.setByte((long)j, (byte)(i2 + j));
                ++j;
            }
            lFragmentedMemory1.add((ContiguousMemoryInterface)lOffHeapMemory);
        }
        lFragmentedMemory1.writeBytesToFileChannel(lFileChannel1, 511L);
        lFragmentedMemory1.free();
        lFileChannel1.close();
        Assert.assertTrue((boolean)lTempFile.exists());
        Assert.assertEquals((long)13411L, (long)lTempFile.length());
        FileChannel lFileChannel2 = FileChannel.open(lTempFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        Assert.assertEquals((long)13411L, (long)lFileChannel2.size());
        FragmentedMemory lFragmentedMemory2 = new FragmentedMemory();
        for (i = 0; i < 100; ++i) {
            OffHeapMemory lOffHeapMemory = new OffHeapMemory(129L);
            lFragmentedMemory2.add((ContiguousMemoryInterface)lOffHeapMemory);
        }
        lFragmentedMemory2.readBytesFromFileChannel(lFileChannel2, 511L, lFragmentedMemory2.getSizeInBytes());
        for (i = 0; i < 100; ++i) {
            ContiguousMemoryInterface lContiguousMemoryInterface = lFragmentedMemory2.get(i);
            int j = 0;
            while ((long)j < lContiguousMemoryInterface.getSizeInBytes()) {
                Assert.assertEquals((long)((byte)(i + j)), (long)lContiguousMemoryInterface.getByte((long)j));
                ++j;
            }
        }
        lFragmentedMemory2.free();
        lFileChannel2.close();
    }

    @Test
    public void testSplitEven() throws IOException {
        OffHeapMemory lMemory = OffHeapMemory.allocateShorts((long)15L);
        FragmentedMemory lSplit = FragmentedMemory.split((ContiguousMemoryInterface)lMemory, (long)3L);
        Assert.assertEquals((long)3L, (long)lSplit.getNumberOfFragments());
        Assert.assertEquals((long)10L, (long)lSplit.get(0).getSizeInBytes());
    }

    @Test
    public void testSplitUneven() throws IOException {
        OffHeapMemory lMemory = OffHeapMemory.allocateShorts((long)16L);
        FragmentedMemory lSplit = FragmentedMemory.split((ContiguousMemoryInterface)lMemory, (long)3L);
        Assert.assertEquals((long)3L, (long)lSplit.getNumberOfFragments());
        Assert.assertEquals((long)10L, (long)lSplit.get(0).getSizeInBytes());
        Assert.assertEquals((long)12L, (long)lSplit.get(2).getSizeInBytes());
    }

    @Test
    public void testByteBuffers() throws IOException {
        int i;
        FragmentedMemory lFragmentedMemory = new FragmentedMemory();
        for (i = 0; i < 10; ++i) {
            ByteBuffer lByteBuffer = ByteBuffer.allocateDirect(10);
            lByteBuffer.clear();
            while (lByteBuffer.hasRemaining()) {
                lByteBuffer.put((byte)i);
            }
            lByteBuffer.clear();
            lFragmentedMemory.add((Buffer)lByteBuffer);
        }
        for (i = 0; i < 10; ++i) {
            ContiguousMemoryInterface lContiguousMemoryInterface = lFragmentedMemory.get(i);
            byte lByte = lContiguousMemoryInterface.getByte(0L);
            Assert.assertEquals((float)i, (float)lByte, (float)0.0f);
        }
    }

    @Test
    public void testConsolidate() throws IOException {
        FragmentedMemory lFragmentedMemory = new FragmentedMemory();
        for (int i = 0; i < 10; ++i) {
            ByteBuffer lByteBuffer = ByteBuffer.allocateDirect(10);
            lByteBuffer.clear();
            while (lByteBuffer.hasRemaining()) {
                lByteBuffer.put((byte)i);
            }
            lByteBuffer.clear();
            lFragmentedMemory.add((Buffer)lByteBuffer);
        }
        OffHeapMemory lMakeConsolidatedCopy = lFragmentedMemory.makeConsolidatedCopy();
    }
}

