/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clij.coremem.buffers.test;

import java.util.NoSuchElementException;
import net.haesleinhuepf.clij.coremem.buffers.ContiguousBuffer;
import org.junit.Assert;
import org.junit.Test;

public class ContiguousBufferTests {
    @Test
    public void test() {
        ContiguousBuffer lContiguousBuffer = ContiguousBuffer.allocate((long)124L);
        Assert.assertEquals((long)124L, (long)lContiguousBuffer.remainingBytes());
        Assert.assertEquals((long)124L, (long)lContiguousBuffer.getSizeInBytes());
        Assert.assertEquals((long)124L, (long)lContiguousBuffer.getContiguousMemory().getSizeInBytes());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemaining(124L));
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingChar());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingShort());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingInt());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingLong());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingFloat());
        Assert.assertTrue((boolean)lContiguousBuffer.hasRemainingDouble());
        Assert.assertTrue((boolean)lContiguousBuffer.isPositionValid());
        int i = 0;
        while (lContiguousBuffer.hasRemainingByte()) {
            lContiguousBuffer.writeByte((byte)i++);
            Assert.assertEquals((long)(124 - i), (long)lContiguousBuffer.remainingBytes());
        }
        lContiguousBuffer.rewind();
        i = 0;
        while (lContiguousBuffer.hasRemainingByte()) {
            Assert.assertEquals((long)i++, (long)lContiguousBuffer.readByte());
        }
        lContiguousBuffer.setPosition(100L);
        lContiguousBuffer.pushPosition();
        lContiguousBuffer.writeFloat(1.0f);
        lContiguousBuffer.writeFloat(1.0f);
        lContiguousBuffer.writeFloat(1.0f);
        lContiguousBuffer.writeFloat(1.0f);
        lContiguousBuffer.popPosition();
        Assert.assertEquals((double)1.0, (double)lContiguousBuffer.readFloat(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)lContiguousBuffer.readFloat(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)lContiguousBuffer.readFloat(), (double)0.01);
        Assert.assertEquals((double)1.0, (double)lContiguousBuffer.readFloat(), (double)0.01);
        Assert.assertNotEquals((double)1.0, (double)lContiguousBuffer.readFloat(), (double)0.01);
        try {
            lContiguousBuffer.popPosition();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        ContiguousBuffer lAnotherContiguousBuffer = ContiguousBuffer.allocate((long)62L);
        lAnotherContiguousBuffer.fillBytes((byte)0);
        lAnotherContiguousBuffer.rewind();
        lContiguousBuffer.rewind();
        lContiguousBuffer.writeContiguousMemory(lAnotherContiguousBuffer.getContiguousMemory());
        Assert.assertEquals((long)62L, (long)lAnotherContiguousBuffer.remainingBytes());
        lContiguousBuffer.writeContiguousBuffer(lAnotherContiguousBuffer);
        Assert.assertEquals((long)0L, (long)lContiguousBuffer.remainingBytes());
        Assert.assertEquals((long)0L, (long)lAnotherContiguousBuffer.remainingBytes());
    }
}

