/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.utils;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StringUtil {
    private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_");

    @Nonnull
    public static String humanize(@Nonnull String str) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0, (Object)"The string cannot be null");
        StringBuilder builder = new StringBuilder();
        str = str.toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
        String[] segments = UNDERSCORE_PATTERN.split(str);
        builder.append(StringUtil.capitalize(segments[0]));
        for (int i = 1; i < segments.length; ++i) {
            builder.append(" ");
            builder.append(StringUtil.capitalize(segments[i]));
        }
        return builder.toString();
    }

    @Nonnull
    public static String dehumanize(@Nonnull String str) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0, (Object)"The string cannot be null");
        return str.toUpperCase(Locale.ROOT).replace(" ", "_").replace("-", "_");
    }

    @Nonnull
    public static String capitalize(@Nonnull String str) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0, (Object)"The string cannot be null");
        int strLen = str.length();
        StringBuffer buffer = new StringBuffer(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static boolean isBlank(@Nullable String str) {
        if (str == null) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

