/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.utils;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JsonUtil {
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");

    @Nonnull
    public static JsonElement parse(@Nonnull String json) {
        Preconditions.checkArgument((json != null ? 1 : 0) != 0, (Object)"JSON string should not be null");
        return new JsonParser().parse(json);
    }

    @Nonnull
    public static JsonElement parse(@Nonnull BufferedReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"reader should not be null");
        return new JsonParser().parse((Reader)reader);
    }

    @Nullable
    public static JsonElement getFromPath(@Nonnull JsonObject root, @Nonnull String path) {
        String[] seg;
        Preconditions.checkArgument((root != null ? 1 : 0) != 0, (Object)"root object should not be null");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path should not be null");
        for (String element : seg = DOT_SPLIT.split(path)) {
            JsonElement elem;
            if (root != null) {
                elem = root.get(element);
                if (elem == null) {
                    return null;
                }
                if (!elem.isJsonObject()) {
                    return elem;
                }
            } else {
                return null;
            }
            root = elem.getAsJsonObject();
        }
        return root;
    }

    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

