/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.guizhanlib.updater.AbstractGuizhanBuildsUpdater;
import net.guizhanss.guizhanlib.utils.JsonUtil;

class UpdaterTask
implements Runnable {
    private final AbstractGuizhanBuildsUpdater updater;
    private String workingDirectory;
    private JsonObject repoInfo = null;
    private JsonObject updateInfo = null;

    UpdaterTask(AbstractGuizhanBuildsUpdater updater) {
        this.updater = updater;
    }

    @Override
    public void run() {
        this.getRepoInfo();
        String format = this.getVersionFormat();
        if (format == null) {
            this.updater.log(Level.SEVERE, this.updater.getLocalizedString("invalid_version_format", "Cannot get version format. Maybe the developer did not configure the updater correctly?"), new Object[0]);
            return;
        }
        if (!this.checkVersion(format)) {
            this.updater.log(Level.WARNING, this.updater.getLocalizedString("invalid_version", "You are using an unofficial version, which is not downloaded from Guizhan Builds. The updater has stopped."), new Object[0]);
            return;
        }
        if (this.hasUpdate()) {
            if (this.updater.checkOnly()) {
                this.sendUpdateNotification();
            } else {
                this.update();
            }
        }
    }

    private void getRepoInfo() {
        try {
            URL repos = new URL(this.updater.getReposFileURL());
            JsonObject reposJson = (JsonObject)JsonUtil.parse(this.fetch(repos));
            String key = this.updater.getRepoKey();
            JsonElement repoInfo = null;
            while (key != null && (repoInfo = JsonUtil.getFromPath(reposJson, key)) != null) {
                if (JsonUtil.getFromPath((JsonObject)repoInfo, "type").getAsString().equals("redirect")) {
                    key = JsonUtil.getFromPath((JsonObject)repoInfo, "options.repo").getAsString();
                    continue;
                }
                key = null;
            }
            if (repoInfo == null) {
                throw new IllegalStateException("Repository information is not found");
            }
            this.repoInfo = (JsonObject)repoInfo;
            JsonElement customDir = JsonUtil.getFromPath(this.repoInfo, "options.customDir");
            this.workingDirectory = customDir != null ? customDir.getAsString() : MessageFormat.format("{0}/{1}/{2}", this.updater.getUser(), this.updater.getRepo(), this.updater.getBranch());
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException | MalformedURLException ex) {
            this.updater.log(Level.SEVERE, this.updater.getLocalizedString("cannot_find_repo", "Cannot find repo in Guizhan Builds."), ex);
        }
    }

    @Nullable
    private String getVersionFormat() {
        try {
            return JsonUtil.getFromPath(this.repoInfo, "options.target.version").getAsString();
        }
        catch (IllegalStateException | NullPointerException ex) {
            return null;
        }
    }

    private boolean checkVersion(String format) {
        String regex = format.replace("(", "\\(").replace(")", "\\)").replace("{version}", "\\d{1,6}").replace("{git_commit}", "([a-z0-9]{7})").replace("{year}", "\\d{1,4}").replace("{month}", "\\d{1,2}").replace("{day}", "\\d{1,2}");
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(this.updater.getPlugin().getDescription().getVersion());
        return m.matches();
    }

    private boolean hasUpdate() {
        try {
            boolean needUpdate;
            URL buildsUrl = new URL(this.updater.getBuildsInfo(this.workingDirectory));
            JsonObject buildsJson = (JsonObject)JsonUtil.parse(this.fetch(buildsUrl));
            JsonArray builds = (JsonArray)JsonUtil.getFromPath(buildsJson, "builds");
            JsonObject build = null;
            for (int i = builds.size() - 1; i >= 0 && !(build = (JsonObject)builds.get(i)).get("success").getAsBoolean(); --i) {
                build = null;
            }
            if (build == null) {
                this.updater.log(Level.SEVERE, this.updater.getLocalizedString("no_successful_builds", "There is no successful build in Guizhan Builds. How did you do this?"), new Object[0]);
                return false;
            }
            String pluginName = JsonUtil.getFromPath(this.repoInfo, "options.target.name").getAsString();
            boolean bl = needUpdate = !MessageFormat.format("{0}-{1}.jar", pluginName, this.updater.getPlugin().getDescription().getVersion()).equals(build.get("target").getAsString());
            if (!needUpdate) {
                this.updater.log(Level.INFO, this.updater.getLocalizedString("latest", "{0} is up-to-date."), this.updater.getPlugin().getName());
                return false;
            }
            this.updateInfo = build;
            return true;
        }
        catch (NullPointerException | MalformedURLException ex) {
            this.updater.log(Level.SEVERE, this.updater.getLocalizedString("an_error_has_occurred", "An error has occurred while checking for update"), new Object[0]);
            return false;
        }
    }

    private void sendUpdateNotification() {
        this.updater.log(Level.INFO, this.updater.getLocalizedString("need_update", "{0} needs to be updated."), this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, this.updater.getLocalizedString("download_notification", "Since this updater is set to check update only, you need to download the new version of {0} manually from Guizhan Builds, or disable checkOnly option."), this.updater.getPlugin().getName());
    }

    private void update() {
        String targetFilename = this.updateInfo.get("target").getAsString();
        this.updater.log(Level.INFO, this.updater.getLocalizedString("need_update", "{0} needs to be updated."), this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, this.updater.getLocalizedString("downloading", "Downloading {0} - Build {1}"), this.updater.getPlugin().getName(), this.updateInfo.get("id").getAsString());
        try {
            int read;
            BufferedInputStream input = new BufferedInputStream(new URL(this.updater.getTargetUrl(this.workingDirectory, targetFilename)).openStream());
            FileOutputStream output = new FileOutputStream(new File("plugins/" + this.updater.getPlugin().getServer().getUpdateFolder(), this.updater.getFile().getName()));
            byte[] data = new byte[1024];
            while ((read = input.read(data, 0, 1024)) != -1) {
                output.write(data, 0, read);
            }
        }
        catch (Exception ex) {
            this.updater.log(Level.SEVERE, ex, MessageFormat.format(this.updater.getLocalizedString("update_fail", "Failed to update {0}"), this.updater.getPlugin().getName()), new Object[0]);
            return;
        }
        this.updater.log(Level.INFO, " ", new Object[0]);
        this.updater.log(Level.INFO, this.updater.getLocalizedString("info_auto_update", "============== Auto update =============="), new Object[0]);
        this.updater.log(Level.INFO, this.updater.getLocalizedString("info_auto_update_1", "Downloaded {0} Build {1}"), this.updater.getPlugin().getName(), this.updateInfo.get("id").getAsString());
        this.updater.log(Level.INFO, this.updater.getLocalizedString("info_auto_update_2", "Restart server to update"), new Object[0]);
        this.updater.log(Level.INFO, " ", new Object[0]);
    }

    @Nullable
    private String fetch(@Nonnull URL url) {
        try {
            StringBuilder content = new StringBuilder();
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            connection.addRequestProperty("User-Agent", "Guizhan Updater");
            connection.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                content.append(line);
                line = reader.readLine();
            }
            return content.toString();
        }
        catch (IOException | NullPointerException ex) {
            this.updater.log(Level.WARNING, this.updater.getLocalizedString("cannot_fetch_info", "Cannot fetch info from Guizhan Builds"), ex);
            return null;
        }
    }
}

