/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.updater;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.JsonUtil;

class UpdaterLocalization {
    private final JsonObject localizations;

    @ParametersAreNonnullByDefault
    public UpdaterLocalization(InputStream stream) {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"Input stream cannot be null");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        this.localizations = (JsonObject)JsonUtil.parse(reader);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public String getLocalization(String lang, String path) {
        JsonElement locale = JsonUtil.getFromPath(this.localizations, lang + "." + path);
        if (locale != null && locale.isJsonObject()) {
            return locale.getAsString();
        }
        return null;
    }
}

