/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.updater;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.updater.UpdaterLocalization;
import net.guizhanss.guizhanlib.updater.UpdaterTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractGuizhanBuildsUpdater {
    private final Plugin plugin;
    private final File file;
    private final String user;
    private final String repo;
    private final String branch;
    private final boolean checkOnly;
    private UpdaterLocalization localization;
    private Logger logger;

    @ParametersAreNonnullByDefault
    public AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch, boolean checkOnly) {
        this.plugin = plugin;
        this.file = file;
        this.user = user;
        this.repo = repo;
        this.branch = branch;
        this.checkOnly = checkOnly;
        this.logger = plugin.getLogger();
        this.prepareUpdateFolder();
        this.initLocalization();
    }

    @Deprecated
    @ParametersAreNonnullByDefault
    public AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch, boolean checkOnly, String lang) {
        this(plugin, file, user, repo, branch, checkOnly);
    }

    private void prepareUpdateFolder() {
        File dir = new File("plugins/" + Bukkit.getUpdateFolder());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private void initLocalization() {
        InputStream stream = AbstractGuizhanBuildsUpdater.class.getResourceAsStream("/updater.json");
        this.localization = new UpdaterLocalization(stream);
    }

    @Nonnull
    public abstract String getBuildsURL();

    @Nonnull
    public abstract String getLanguage();

    public void start() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, (Runnable)new UpdaterTask(this));
    }

    @Nonnull
    public String getReposFileURL() {
        return this.getBuildsURL() + "/repos.json";
    }

    @Nonnull
    public String getRepoKey() {
        return MessageFormat.format("{0}/{1}:{2}", this.user, this.repo, this.branch);
    }

    @Nonnull
    public String getBuildsInfo(@Nonnull String directory) {
        return MessageFormat.format("{0}/f/{1}/builds.json", this.getBuildsURL(), directory);
    }

    public void log(Level level, String message, Object ... args) {
        this.logger.log(level, () -> MessageFormat.format(message, args));
    }

    public void log(Level level, Exception exception, String message, Object ... args) {
        this.logger.log(level, exception, () -> MessageFormat.format(message, args));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getTargetUrl(String directory, String target) {
        return MessageFormat.format("{0}/f/{1}/{2}", this.getBuildsURL(), directory, target);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getLocalizedString(String key, String defaultValue) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The localization key cannot be null.");
        Preconditions.checkArgument((defaultValue != null ? 1 : 0) != 0, (Object)"The localization key cannot be null.");
        String result = this.localization.getLocalization(this.getLanguage(), key);
        return Objects.requireNonNullElse(result, defaultValue);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public File getFile() {
        return this.file;
    }

    public String getUser() {
        return this.user;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean checkOnly() {
        return this.checkOnly;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

