/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.slimefun.addon;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.io.File;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.guizhanlib.slimefun.addon.AddonConfig;
import net.guizhanss.guizhanlib.slimefun.addon.Environment;
import net.guizhanss.guizhanlib.slimefun.addon.Scheduler;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

@ParametersAreNonnullByDefault
public abstract class AbstractAddon
extends JavaPlugin
implements SlimefunAddon {
    private static AbstractAddon instance;
    private final Environment environment;
    private final String githubUser;
    private final String githubRepo;
    private final String githubBranch;
    private final String autoUpdateKey;
    private final String bugTrackerURL;
    private AddonConfig config;
    private int slimefunTickCount;
    private Scheduler scheduler;
    private boolean loading;
    private boolean enabling;
    private boolean disabling;
    private boolean autoUpdateEnabled;

    public AbstractAddon(String githubUser, String githubRepo, String githubBranch, String autoUpdateKey) {
        this.environment = Environment.LIVE;
        this.githubUser = githubUser;
        this.githubRepo = githubRepo;
        this.githubBranch = githubBranch;
        this.autoUpdateKey = autoUpdateKey;
        this.bugTrackerURL = MessageFormat.format("https://github.com/{0}/{1}/issues", githubUser, githubRepo);
        this.validate();
    }

    @Deprecated
    public AbstractAddon(String githubUser, String githubRepo, String githubBranch, String autoUpdateKey, String updaterLangKey) {
        this(githubUser, githubRepo, githubBranch, autoUpdateKey);
    }

    public AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file, String githubUser, String githubRepo, String githubBranch, String autoUpdateKey) {
        this(loader, description, dataFolder, file, githubUser, githubRepo, githubBranch, autoUpdateKey, Environment.TESTING);
    }

    AbstractAddon(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file, String githubUser, String githubRepo, String githubBranch, String autoUpdateKey, Environment environment) {
        super(loader, description, dataFolder, file);
        this.environment = environment;
        this.githubUser = githubUser;
        this.githubBranch = githubBranch;
        this.githubRepo = githubRepo;
        this.autoUpdateKey = autoUpdateKey;
        this.bugTrackerURL = MessageFormat.format("https://github.com/{0}/{1}/issues", githubUser, githubRepo);
        this.validate();
    }

    @Nonnull
    public static <T extends AbstractAddon> T getInstance() {
        return (T)((Object)Objects.requireNonNull(instance, "Addon is not enabled!"));
    }

    @Nonnull
    public static AddonConfig getAddonConfig() {
        return ((AbstractAddon)((Object)AbstractAddon.getInstance())).config;
    }

    @Nonnull
    public static Scheduler getScheduler() {
        return ((AbstractAddon)((Object)AbstractAddon.getInstance())).scheduler;
    }

    public static int getSlimefunTickCount() {
        return ((AbstractAddon)((Object)AbstractAddon.getInstance())).slimefunTickCount;
    }

    @Nonnull
    public static PluginCommand getPluginCommand(@Nonnull String command) {
        Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"command should not be null");
        return Objects.requireNonNull(AbstractAddon.getInstance().getCommand(command));
    }

    @Nonnull
    public static NamespacedKey createKey(String key) {
        return new NamespacedKey(AbstractAddon.getInstance(), key);
    }

    public static void log(@Nonnull Level level, @Nonnull String message, Object ... args) {
        Preconditions.checkArgument((level != null ? 1 : 0) != 0, (Object)"log level should not be null");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"log message should not be null");
        AbstractAddon.getInstance().getLogger().log(level, ChatUtil.color(MessageFormat.format(message, args)));
    }

    public static void log(@Nonnull Level level, @Nonnull Throwable ex, @Nonnull String message, Object ... args) {
        Preconditions.checkArgument((level != null ? 1 : 0) != 0, (Object)"log level should not be null");
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"log message should not be null");
        AbstractAddon.getInstance().getLogger().log(level, ex, () -> ChatUtil.color(MessageFormat.format(message, args)));
    }

    public static void sendConsole(@Nonnull String message, Object ... args) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"log message should not be null");
        Bukkit.getConsoleSender().sendMessage("[" + AbstractAddon.getInstance().getName() + "] " + ChatUtil.color(MessageFormat.format(message, args)));
    }

    private void validate() {
        if (instance != null) {
            throw new IllegalStateException("Addon " + instance.getName() + " is already using this GuizhanLib, Shade an relocate your own!");
        }
        if (!this.githubUser.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid githubUser");
        }
        if (!this.githubRepo.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid githubRepo");
        }
        if (!this.githubBranch.matches("[\\w-]+")) {
            throw new IllegalArgumentException("Invalid githubBranch");
        }
    }

    public final void onLoad() {
        if (this.loading) {
            throw new IllegalStateException(this.getName() + " is already loading! Do not call super.onLoad()!");
        }
        this.loading = true;
        try {
            this.load();
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        finally {
            this.loading = false;
        }
    }

    public final void onEnable() {
        if (this.enabling) {
            throw new IllegalStateException(this.getName() + " is already enabling! Do not call super.onEnable()!");
        }
        this.enabling = true;
        instance = this;
        boolean brokenConfig = false;
        try {
            this.config = new AddonConfig("config.yml");
        }
        catch (RuntimeException e) {
            brokenConfig = true;
            e.printStackTrace();
        }
        if (this.autoUpdateKey == null || this.autoUpdateKey.isEmpty()) {
            brokenConfig = true;
            this.handleException(new IllegalStateException("Invalid autoUpdateKey"));
        }
        if (!brokenConfig && !this.config.getDefaults().contains(this.autoUpdateKey, true)) {
            brokenConfig = true;
            this.handleException(new IllegalStateException("Auto update key missing from the default config!"));
        }
        if (this.environment == Environment.LIVE) {
            if (brokenConfig) {
                this.handleException(new IllegalArgumentException("Auto update is not configured correctly"));
            } else if (this.config.getBoolean(this.autoUpdateKey)) {
                this.autoUpdateEnabled = true;
                this.autoUpdate();
            }
        }
        this.scheduler = new Scheduler((Plugin)this);
        if (this.environment == Environment.LIVE) {
            this.scheduler.repeat(Slimefun.getTickerTask().getTickRate(), () -> ++this.slimefunTickCount);
        }
        try {
            this.enable();
        }
        catch (RuntimeException ex) {
            this.handleException(ex);
        }
        finally {
            this.enabling = false;
        }
    }

    public final void onDisable() {
        if (this.disabling) {
            throw new IllegalStateException(this.getName() + " is already disabling! Do not call super.onDisable()!");
        }
        this.disabling = true;
        try {
            this.disable();
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        finally {
            this.disabling = false;
            this.slimefunTickCount = 0;
            instance = null;
            this.config = null;
        }
    }

    protected void load() {
    }

    protected abstract void enable();

    protected abstract void disable();

    protected void autoUpdate() {
    }

    private void handleException(RuntimeException ex) {
        switch (this.environment) {
            case LIVE: {
                ex.printStackTrace();
                break;
            }
            case TESTING: {
                throw ex;
            }
        }
    }

    @Nonnull
    public final JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nonnull
    public String getBugTrackerURL() {
        return this.bugTrackerURL;
    }

    @Nonnull
    public Environment getEnvironment() {
        return this.environment;
    }

    public final boolean isAutoUpdateEnabled() {
        return this.autoUpdateEnabled;
    }

    @Nonnull
    public final FileConfiguration getConfig() {
        return this.config;
    }

    public final void saveDefaultConfig() {
    }
}

