/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.potion;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import org.bukkit.potion.PotionEffectType;

public final class PotionEffectTypeHelper {
    @Nonnull
    public static String getName(@Nonnull PotionEffectType type) {
        return LanguageHelper.getLangOrKey(PotionEffectTypeHelper.getKey(type));
    }

    @Nonnull
    public static String getKey(@Nonnull PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u836f\u6c34\u6548\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        String key = Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_18) ? type.getKey().getKey() : (type == PotionEffectType.CONFUSION ? "nausea" : (type == PotionEffectType.DAMAGE_RESISTANCE ? "resistance" : (type == PotionEffectType.FAST_DIGGING ? "haste" : (type == PotionEffectType.HARM ? "instant_damage" : (type == PotionEffectType.HEAL ? "instant_health" : (type == PotionEffectType.INCREASE_DAMAGE ? "strength" : (type == PotionEffectType.JUMP ? "jump_boost" : (type == PotionEffectType.SLOW ? "slowness" : (type == PotionEffectType.SLOW_DIGGING ? "mining_fatigue" : type.getName().toLowerCase())))))))));
        return "effect.minecraft." + key;
    }

    private PotionEffectTypeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

