/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.inventory;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import net.guizhanss.guizhanlib.minecraft.MinecraftTag;
import net.guizhanss.guizhanlib.minecraft.helper.MaterialHelper;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class ItemStackHelper {
    @Nonnull
    public static String getDisplayName(@Nonnull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"\u7269\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return ItemStackHelper.getName(item);
    }

    @Nonnull
    public static String getName(@Nonnull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"\u7269\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        if (MinecraftTag.POTION_WITH_TIPPED_ARROW.isTagged(item)) {
            String potion = ((PotionMeta)item.getItemMeta()).getBasePotionData().getType().toString().toLowerCase();
            return LanguageHelper.getLangOrKey(MaterialHelper.getKey(item.getType()) + ".effect." + potion);
        }
        if (item.getType() == Material.PLAYER_HEAD || item.getType() == Material.PLAYER_WALL_HEAD) {
            return ItemStackHelper.getPlayerSkullName(item);
        }
        return MaterialHelper.getName(item.getType());
    }

    @Nonnull
    private static String getPlayerSkullName(@Nonnull ItemStack skull) {
        Preconditions.checkArgument((skull != null ? 1 : 0) != 0, (Object)"\u7269\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null && meta.hasOwner()) {
            return String.format(LanguageHelper.getLangOrKey("block.minecraft.player_head.named"), meta.getOwningPlayer().getName());
        }
        return LanguageHelper.getLangOrKey("block.minecraft.player_head");
    }

    private ItemStackHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

