/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import org.bukkit.entity.Villager;

public final class VillagerHelper {
    @Nonnull
    public static String getProfessionName(@Nonnull Villager.Profession profession) {
        return LanguageHelper.getLangOrKey(VillagerHelper.getProfessionKey(profession));
    }

    @Nonnull
    public static String getProfessionKey(@Nonnull Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"\u6751\u6c11\u804c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
        return "entity.minecraft.villager." + profession.toString().toLowerCase();
    }

    @Nonnull
    public static String getProfessionName(@Nonnull String profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"\u6751\u6c11\u804c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Villager.Profession villagerProfession = Villager.Profession.valueOf((String)profession);
            return VillagerHelper.getProfessionName(villagerProfession);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    private VillagerHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

