/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Rabbit;

public final class RabbitHelper {
    @Nonnull
    public static String getType(@Nonnull Rabbit.Type type) {
        return Type.fromType(type).getChinese();
    }

    @Nonnull
    public static String getType(@Nonnull String type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u5154\u5b50\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Rabbit.Type rabbitType = Rabbit.Type.valueOf((String)type);
            return Type.fromType(rabbitType).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(type);
        }
    }

    private RabbitHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Type {
        BLACK(Rabbit.Type.BLACK, "\u9ed1\u8272"),
        BLACK_AND_WHITE(Rabbit.Type.BLACK_AND_WHITE, "\u9ed1\u767d\u76f8\u95f4"),
        BROWN(Rabbit.Type.BROWN, "\u8910\u8272"),
        GOLD(Rabbit.Type.GOLD, "\u91d1\u8272"),
        SALT_AND_PEPPER(Rabbit.Type.SALT_AND_PEPPER, "\u80e1\u6912\u76d0\u8272"),
        THE_KILLER_BUNNY(Rabbit.Type.THE_KILLER_BUNNY, "\u6740\u624b\u5154"),
        WHITE(Rabbit.Type.WHITE, "\u767d\u8272");

        private static final Type[] cachedValues;
        private static final Map<Rabbit.Type, Type> typeLookup;
        private final Rabbit.Type type;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Type(Rabbit.Type type, String chinese) {
            this.type = type;
            this.chinese = chinese;
        }

        @Nonnull
        public static Type fromType(@Nonnull Rabbit.Type rabbitType) {
            Preconditions.checkArgument((rabbitType != null ? 1 : 0) != 0, (Object)"\u5154\u5b50\u7684\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return typeLookup.get(rabbitType);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Rabbit.Type getType() {
            return this.type;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Type.values();
            typeLookup = new EnumMap<Rabbit.Type, Type>(Rabbit.Type.class);
            for (Type type : cachedValues) {
                typeLookup.put(type.getType(), type);
            }
        }
    }
}

