/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.entity;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.guizhanlib.utils.StringUtil;
import org.bukkit.entity.Fox;

public final class FoxHelper {
    @Nonnull
    public static String getType(@Nonnull Fox.Type type) {
        return Type.fromType(type).getChinese();
    }

    @Nonnull
    public static String getType(@Nonnull String type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u72d0\u72f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Fox.Type foxType = Fox.Type.valueOf((String)type);
            return Type.fromType(foxType).getChinese();
        }
        catch (IllegalArgumentException ex) {
            return StringUtil.humanize(type);
        }
    }

    private FoxHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum Type {
        RED(Fox.Type.RED, "\u7ea2\u72d0"),
        SNOW(Fox.Type.SNOW, "\u96ea\u72d0");

        private static final Type[] cachedValues;
        private static final Map<Fox.Type, Type> typeLookup;
        private final Fox.Type type;
        private final String chinese;

        @ParametersAreNonnullByDefault
        private Type(Fox.Type type, String chinese) {
            this.type = type;
            this.chinese = chinese;
        }

        @Nonnull
        public static Type fromType(@Nonnull Fox.Type foxType) {
            Preconditions.checkArgument((foxType != null ? 1 : 0) != 0, (Object)"\u72d0\u72f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return typeLookup.get(foxType);
        }

        @Nonnull
        public String toString() {
            return this.getChinese();
        }

        public Fox.Type getType() {
            return this.type;
        }

        public String getChinese() {
            return this.chinese;
        }

        static {
            cachedValues = Type.values();
            typeLookup = new EnumMap<Fox.Type, Type>(Fox.Type.class);
            for (Type type : cachedValues) {
                typeLookup.put(type.getType(), type);
            }
        }
    }
}

