/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.utils;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class InventoryUtil {
    @ParametersAreNonnullByDefault
    public static void push(Player p, ItemStack ... itemStacks) {
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"player should not be null");
        Preconditions.checkArgument((itemStacks != null ? 1 : 0) != 0, (Object)"at least one ItemStack is required");
        Preconditions.checkArgument((itemStacks.length > 0 ? 1 : 0) != 0, (Object)"at least one ItemStack is required");
        itemStacks = (ItemStack[])Arrays.stream(itemStacks).filter(Objects::nonNull).toArray(ItemStack[]::new);
        HashMap remainingItemMap = p.getInventory().addItem(itemStacks);
        for (ItemStack item : remainingItemMap.values()) {
            p.getWorld().dropItem(p.getLocation(), item.clone());
        }
    }

    private InventoryUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

