/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft.helper.potion;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import net.guizhanss.guizhanlib.minecraft.LanguageHelper;
import org.bukkit.potion.PotionEffectType;

public final class PotionEffectTypeHelper {
    @Nonnull
    public static String getName(@Nonnull PotionEffectType type) {
        return LanguageHelper.getLangOrKey(PotionEffectTypeHelper.getKey(type));
    }

    @Nonnull
    public static String getKey(@Nonnull PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u836f\u6c34\u6548\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        String key = type.getName().toLowerCase();
        if (Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_18)) {
            key = type.getName();
        } else if (type == PotionEffectType.CONFUSION) {
            key = "nausea";
        } else if (type == PotionEffectType.DAMAGE_RESISTANCE) {
            key = "resistance";
        } else if (type == PotionEffectType.FAST_DIGGING) {
            key = "haste";
        } else if (type == PotionEffectType.HARM) {
            key = "instant_damage";
        } else if (type == PotionEffectType.HEAL) {
            key = "instant_health";
        } else if (type == PotionEffectType.INCREASE_DAMAGE) {
            key = "strength";
        } else if (type == PotionEffectType.JUMP) {
            key = "jump_boost";
        } else if (type == PotionEffectType.SLOW) {
            key = "slowness";
        } else if (type == PotionEffectType.SLOW_DIGGING) {
            key = "mining_fatigue";
        }
        return "effect.minecraft." + key;
    }

    private PotionEffectTypeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

