/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.minecraft;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LanguageHelper {
    private static final Gson GSON = new Gson();
    private static Map<String, String> lang;

    public static void loadFromStream(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        lang = (Map)GSON.fromJson((Reader)reader, type);
    }

    @Nonnull
    public static String getLangOrDefault(@Nonnull String key, @Nonnull String defaultVal) {
        String lang = LanguageHelper.getLangOrNull(key);
        return lang != null ? lang : defaultVal;
    }

    @Nonnull
    public static String getLangOrKey(@Nonnull String key) {
        return LanguageHelper.getLangOrDefault(key, key);
    }

    @Nullable
    public static String getLangOrNull(@Nonnull String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"\u952e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        return lang.get(key);
    }

    private LanguageHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

