/*
 * Decompiled with CFR 0.152.
 */
package net.goui.flogger.testing.junit5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.goui.flogger.testing.LevelClass;
import net.goui.flogger.testing.SetLogLevel;
import net.goui.flogger.testing.api.LogInterceptor;
import net.goui.flogger.testing.api.TestingApi;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class FloggerTestExtension
extends TestingApi<FloggerTestExtension>
implements BeforeEachCallback,
AfterEachCallback {
    private static final Pattern EXPECTED_TEST_CLASS_NAME = Pattern.compile("((?:[^.]+\\.)*[^.]+)Test");
    private final AtomicReference<TestingApi.ApiHook> apiHook = new AtomicReference();

    public static FloggerTestExtension forClassUnderTest(LevelClass level) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        return FloggerTestExtension.forClassOrPackage(FloggerTestExtension.guessClassUnderTest(caller), level);
    }

    public static FloggerTestExtension forPackageUnderTest(LevelClass level) {
        Class<?> caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        return FloggerTestExtension.forClassOrPackage(FloggerTestExtension.guessPackageUnderTest(caller), level);
    }

    public static FloggerTestExtension forClass(Class<?> clazz, LevelClass level) {
        return FloggerTestExtension.forClassOrPackage(FloggerTestExtension.loggerNameOf(clazz), level);
    }

    public static FloggerTestExtension forPackage(Package pkg, LevelClass level) {
        return FloggerTestExtension.forClassOrPackage(pkg.getName(), level);
    }

    public static FloggerTestExtension forClassOrPackage(String loggerName, LevelClass level) {
        return FloggerTestExtension.forLevelMap((Map<String, LevelClass>)ImmutableMap.of((Object)loggerName, (Object)level));
    }

    public static FloggerTestExtension forLevelMap(Map<String, LevelClass> levelMap) {
        return FloggerTestExtension.create(levelMap, null);
    }

    public static FloggerTestExtension create(Map<String, LevelClass> levelMap, @Nullable LogInterceptor interceptor) {
        return new FloggerTestExtension(levelMap, interceptor);
    }

    private FloggerTestExtension(Map<String, LevelClass> levelMap, @Nullable LogInterceptor interceptor) {
        super(levelMap, interceptor);
    }

    protected FloggerTestExtension api() {
        return this;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        ImmutableMap extraLogLevels = FloggerTestExtension.getLevelMap((Class)((Class)extensionContext.getTestClass().orElseThrow()), (ImmutableList)((ImmutableList)Arrays.stream(((Method)extensionContext.getTestMethod().orElseThrow()).getAnnotations()).filter(SetLogLevel.class::isInstance).map(SetLogLevel.class::cast).collect(ImmutableList.toImmutableList())));
        Preconditions.checkState((this.apiHook.getAndSet(this.install(true, extraLogLevels)) == null ? 1 : 0) != 0, (Object)"API hook must never be installed twice");
    }

    public void afterEach(ExtensionContext extensionContext) {
        TestingApi.ApiHook hook = this.apiHook.getAndSet(null);
        if (hook != null) {
            hook.close();
        }
    }
}

