/*
 * Decompiled with CFR 0.152.
 */
package eventstore;

import eventstore.Commit;
import eventstore.ConcurrencyException;
import eventstore.DuplicateCommitException;
import eventstore.DuplicateCommitException$;
import eventstore.IPersistStreams;
import eventstore.Logging;
import eventstore.Logging$class;
import eventstore.Snapshot;
import eventstore.StreamHead;
import java.util.UUID;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001\u0015\u0011\u0011$\u00138NK6|'/\u001f)feNL7\u000f^3oG\u0016,enZ5oK*\t1!\u0001\u0006fm\u0016tGo\u001d;pe\u0016\u001c\u0001a\u0005\u0003\u0001\r1\u0001\u0002CA\u0004\u000b\u001b\u0005A!\"A\u0005\u0002\u000bM\u001c\u0017\r\\1\n\u0005-A!AB!osJ+g\r\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\ty\u0011\nU3sg&\u001cHo\u0015;sK\u0006l7\u000f\u0005\u0002\u000e#%\u0011!C\u0001\u0002\b\u0019><w-\u001b8h\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u000e\u0001!9\u0001\u0004\u0001a\u0001\n\u0003I\u0012aB2p[6LGo]\u000b\u00025A\u00191\u0004\t\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0013%lW.\u001e;bE2,'BA\u0010\t\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Cq\u0011A\u0001T5tiB\u0011QbI\u0005\u0003I\t\u0011aaQ8n[&$\bb\u0002\u0014\u0001\u0001\u0004%\taJ\u0001\fG>lW.\u001b;t?\u0012*\u0017\u000f\u0006\u0002)WA\u0011q!K\u0005\u0003U!\u0011A!\u00168ji\"9A&JA\u0001\u0002\u0004Q\u0012a\u0001=%c!1a\u0006\u0001Q!\ni\t\u0001bY8n[&$8\u000f\t\u0005\ba\u0001\u0001\r\u0011\"\u00012\u0003\u0015AW-\u00193t+\u0005\u0011\u0004cA\u000e!gA\u0011Q\u0002N\u0005\u0003k\t\u0011!b\u0015;sK\u0006l\u0007*Z1e\u0011\u001d9\u0004\u00011A\u0005\u0002a\n\u0011\u0002[3bIN|F%Z9\u0015\u0005!J\u0004b\u0002\u00177\u0003\u0003\u0005\rA\r\u0005\u0007w\u0001\u0001\u000b\u0015\u0002\u001a\u0002\r!,\u0017\rZ:!\u0011\u001di\u0004\u00011A\u0005\u0002e\tA\"\u001e8eSN\u0004\u0018\r^2iK\u0012Dqa\u0010\u0001A\u0002\u0013\u0005\u0001)\u0001\tv]\u0012L7\u000f]1uG\",Gm\u0018\u0013fcR\u0011\u0001&\u0011\u0005\bYy\n\t\u00111\u0001\u001b\u0011\u0019\u0019\u0005\u0001)Q\u00055\u0005iQO\u001c3jgB\fGo\u00195fI\u0002Bq!\u0012\u0001A\u0002\u0013\u0005a)A\u0005t]\u0006\u00048\u000f[8ugV\tq\tE\u0002\u001cA!\u0003\"!D%\n\u0005)\u0013!\u0001C*oCB\u001c\bn\u001c;\t\u000f1\u0003\u0001\u0019!C\u0001\u001b\u0006i1O\\1qg\"|Go]0%KF$\"\u0001\u000b(\t\u000f1Z\u0015\u0011!a\u0001\u000f\"1\u0001\u000b\u0001Q!\n\u001d\u000b!b\u001d8baNDw\u000e^:!\u0011\u001d\u0011\u0006\u00011A\u0005\u0002M\u000baa\u001d;b[B\u001cX#\u0001+\u0011\tm)vKX\u0005\u0003-r\u00111!T1q!\tA6L\u0004\u0002\u000e3&\u0011!LA\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0003Hk&$'B\u0001.\u0003!\tAv,\u0003\u0002a;\niQI^3oi\u0012\u000bG/\u001a+j[\u0016DqA\u0019\u0001A\u0002\u0013\u00051-\u0001\u0006ti\u0006l\u0007o]0%KF$\"\u0001\u000b3\t\u000f1\n\u0017\u0011!a\u0001)\"1a\r\u0001Q!\nQ\u000bqa\u001d;b[B\u001c\b\u0005C\u0003i\u0001\u0011\u0005\u0011.\u0001\u0006j]&$\u0018.\u00197ju\u0016,\u0012\u0001\u000b\u0005\u0006W\u0002!\t\u0001\\\u0001\u0011iJ\fgn]1di&|gnQ8v]R,\u0012!\u001c\t\u0003\u000f9L!a\u001c\u0005\u0003\t1{gn\u001a\u0005\u0006c\u0002!\tA]\u0001\bO\u0016$hI]8n)\u0011Q2/\u001e>\t\u000bQ\u0004\b\u0019A,\u0002\u0011M$(/Z1n\u0013\u0012DQA\u001e9A\u0002]\f1\"\\5o%\u00164\u0018n]5p]B\u0011q\u0001_\u0005\u0003s\"\u00111!\u00138u\u0011\u0015Y\b\u000f1\u0001x\u0003-i\u0017\r\u001f*fm&\u001c\u0018n\u001c8\t\u000bE\u0004A\u0011A?\u0015\u0007y\f\t\u0002\u0005\u0003\u0000\u0003\u001b\u0011c\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f!\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\tQ\u0006\"C\u0002\"\u0003\u001fQ!A\u0017\u0005\t\r\u0005MA\u00101\u0001_\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t9\u0002\u0001C\u0001\u00033\t\u0011bZ3u\rJ|W\u000eV8\u0015\u000by\fY\"!\b\t\u000f\u0005M\u0011Q\u0003a\u0001=\"9\u0011qDA\u000b\u0001\u0004q\u0016aA3oI\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012AB2p[6LG\u000fF\u0002)\u0003OAq!!\u000b\u0002\"\u0001\u0007!%A\u0004biR,W\u000e\u001d;\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u00051r-\u001a;V]\u0012L7\u000f]1uG\",GmQ8n[&$8\u000fF\u0001\u001b\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003k\ta#\\1sW\u000e{W.\\5u\u0003N$\u0015n\u001d9bi\u000eDW\r\u001a\u000b\u0004Q\u0005]\u0002bBA\u0012\u0003c\u0001\rA\t\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003Q9W\r^*ue\u0016\fWn\u001d+p':\f\u0007o\u001d5piR!\u0011qHA#!\u0011y\u0018\u0011I\u001a\n\t\u0005\r\u0013q\u0002\u0002\t\u0013R,'/\u00192mK\"9\u0011qIA\u001d\u0001\u00049\u0018\u0001D7bqRC'/Z:i_2$\u0007bBA&\u0001\u0011\u0005\u0011QJ\u0001\fO\u0016$8K\\1qg\"|G\u000f\u0006\u0004\u0002P\u0005U\u0013q\u000b\t\u0005\u000f\u0005E\u0003*C\u0002\u0002T!\u0011aa\u00149uS>t\u0007B\u0002;\u0002J\u0001\u0007q\u000b\u0003\u0004|\u0003\u0013\u0002\ra\u001e\u0005\b\u00037\u0002A\u0011AA/\u0003-\tG\rZ*oCB\u001c\bn\u001c;\u0015\t\u0005}\u0013Q\r\t\u0004\u000f\u0005\u0005\u0014bAA2\u0011\t9!i\\8mK\u0006t\u0007bBA4\u00033\u0002\r\u0001S\u0001\tg:\f\u0007o\u001d5pi\"1\u00111\u000e\u0001\u0005\u0002%\fQ\u0001];sO\u0016Dq!a\u001c\u0001\t\u0003\t\t(\u0001\u0004sK6|g/Z\u000b\u0005\u0003g\nY\b\u0006\u0004\u0002v\u00055\u0015\u0011\u0013\t\u00057\u0001\n9\b\u0005\u0003\u0002z\u0005mD\u0002\u0001\u0003\t\u0003{\niG1\u0001\u0002\u0000\t\t\u0011)\u0005\u0003\u0002\u0002\u0006\u001d\u0005cA\u0004\u0002\u0004&\u0019\u0011Q\u0011\u0005\u0003\u000f9{G\u000f[5oOB\u0019q!!#\n\u0007\u0005-\u0005BA\u0002B]fD\u0001\"a$\u0002n\u0001\u0007\u0011qO\u0001\u0004]Vl\u0007\u0002CAJ\u0003[\u0002\r!!&\u0002\t1L7\u000f\u001e\t\u0006\u007f\u00065\u0011q\u000f")
public class InMemoryPersistenceEngine
implements IPersistStreams,
Logging {
    private List<Commit> commits;
    private List<StreamHead> heads;
    private List<Commit> undispatched;
    private List<Snapshot> snapshots;
    private Map<UUID, Object> stamps;
    private final String loggerName;
    private final Logger log;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger log$lzycompute() {
        InMemoryPersistenceEngine inMemoryPersistenceEngine = this;
        synchronized (inMemoryPersistenceEngine) {
            if (!this.bitmap$0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public void eventstore$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public List<Commit> commits() {
        return this.commits;
    }

    public void commits_$eq(List<Commit> x$1) {
        this.commits = x$1;
    }

    public List<StreamHead> heads() {
        return this.heads;
    }

    public void heads_$eq(List<StreamHead> x$1) {
        this.heads = x$1;
    }

    public List<Commit> undispatched() {
        return this.undispatched;
    }

    public void undispatched_$eq(List<Commit> x$1) {
        this.undispatched = x$1;
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public void snapshots_$eq(List<Snapshot> x$1) {
        this.snapshots = x$1;
    }

    public Map<UUID, Object> stamps() {
        return this.stamps;
    }

    public void stamps_$eq(Map<UUID, Object> x$1) {
        this.stamps = x$1;
    }

    @Override
    public void initialize() {
        this.log().info("Initialized");
    }

    @Override
    public long transactionCount() {
        return this.commits().size();
    }

    public List<Commit> getFrom(UUID streamId, int minRevision, int maxRevision) {
        List<Commit> list = this.commits();
        synchronized (list) {
            Object object = this.commits().filter((Function1)new Serializable(this, streamId, minRevision, maxRevision){
                public static final long serialVersionUID = 0L;
                private final UUID streamId$1;
                private final int minRevision$1;
                private final int maxRevision$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(Commit x) {
                    UUID uUID = x.streamId();
                    UUID uUID2 = this.streamId$1;
                    if (uUID == null) {
                        if (uUID2 != null) {
                            return false;
                        }
                    } else if (!((Object)uUID).equals(uUID2)) return false;
                    if (x.streamRevision() < this.minRevision$1) return false;
                    if (x.streamRevision() - x.events().size() + 1 > this.maxRevision$1) return false;
                    return true;
                }
                {
                    this.streamId$1 = streamId$1;
                    this.minRevision$1 = minRevision$1;
                    this.maxRevision$1 = maxRevision$1;
                }
            });
            return (List)object;
        }
    }

    public List<Commit> getFrom(long start) {
        return this.commits().dropWhile((Function1)new Serializable(this, start){
            public static final long serialVersionUID = 0L;
            private final long start$1;

            public final boolean apply(Commit s) {
                return s.commitStamp() < this.start$1;
            }
            {
                this.start$1 = start$1;
            }
        });
    }

    public List<Commit> getFromTo(long start, long end) {
        List<Commit> froms = this.getFrom(start);
        return froms.takeWhile((Function1)new Serializable(this, end){
            public static final long serialVersionUID = 0L;
            private final long end$1;

            public final boolean apply(Commit c) {
                return c.commitStamp() <= this.end$1;
            }
            {
                this.end$1 = end$1;
            }
        });
    }

    @Override
    public void commit(Commit attempt) {
        List<Commit> list = this.commits();
        synchronized (list) {
            if (this.commits().contains((Object)attempt)) {
                throw new DuplicateCommitException(DuplicateCommitException$.MODULE$.$lessinit$greater$default$1());
            }
            if (this.commits().exists((Function1)new Serializable(this, attempt){
                public static final long serialVersionUID = 0L;
                private final Commit attempt$1;

                public final boolean apply(Commit c) {
                    UUID uUID = c.streamId();
                    UUID uUID2 = this.attempt$1.streamId();
                    return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null) && c.streamRevision() == this.attempt$1.streamRevision();
                }
                {
                    this.attempt$1 = attempt$1;
                }
            })) {
                throw new ConcurrencyException("Concurrent Write");
            }
            this.stamps_$eq((Map<UUID, Object>)this.stamps().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attempt.commitId()), (Object)BoxesRunTime.boxToLong((long)attempt.commitStamp()))));
            this.commits_$eq((List<Commit>)((List)this.commits().$colon$plus((Object)attempt, List$.MODULE$.canBuildFrom())));
            this.undispatched_$eq((List<Commit>)((List)this.undispatched().$colon$plus((Object)attempt, List$.MODULE$.canBuildFrom())));
            Option head = this.heads().find((Function1)new Serializable(this, attempt){
                public static final long serialVersionUID = 0L;
                private final Commit attempt$1;

                public final boolean apply(StreamHead x) {
                    UUID uUID = x.streamId();
                    UUID uUID2 = this.attempt$1.streamId();
                    return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
                }
                {
                    this.attempt$1 = attempt$1;
                }
            });
            if (head.isDefined()) {
                this.heads_$eq(this.remove(head.get(), this.heads()));
            }
            int snapshotRevision = head.isDefined() ? ((StreamHead)head.get()).snapshotRevision() : 0;
            this.heads_$eq((List<StreamHead>)((List)this.heads().$colon$plus((Object)new StreamHead(attempt.streamId(), attempt.streamRevision(), snapshotRevision), List$.MODULE$.canBuildFrom())));
            return;
        }
    }

    public List<Commit> getUndispatchedCommits() {
        List<Commit> list = this.commits();
        synchronized (list) {
            Object object = this.commits().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InMemoryPersistenceEngine $outer;

                public final boolean apply(Commit c) {
                    return this.$outer.undispatched().contains((Object)c);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return (List)object;
        }
    }

    @Override
    public void markCommitAsDispatched(Commit commit2) {
        List<Commit> list = this.commits();
        synchronized (list) {
            this.undispatched_$eq(this.remove(commit2, this.undispatched()));
            return;
        }
    }

    @Override
    public Iterable<StreamHead> getStreamsToSnapshot(int maxThreshold) {
        List<Commit> list = this.commits();
        synchronized (list) {
            List x = (List)this.heads().filter((Function1)new Serializable(this, maxThreshold){
                public static final long serialVersionUID = 0L;
                private final int maxThreshold$1;

                public final boolean apply(StreamHead x) {
                    return x.headRevision() >= x.snapshotRevision() + this.maxThreshold$1;
                }
                {
                    this.maxThreshold$1 = maxThreshold$1;
                }
            });
            Object object = x.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StreamHead apply(StreamHead stream) {
                    return new StreamHead(stream.streamId(), stream.headRevision(), stream.snapshotRevision());
                }
            }, List$.MODULE$.canBuildFrom());
            return (Iterable)object;
        }
    }

    @Override
    public Option<Snapshot> getSnapshot(UUID streamId, int maxRevision) {
        this.log().warn("In memory doesn't support snapshots yet");
        return None$.MODULE$;
    }

    @Override
    public boolean addSnapshot(Snapshot snapshot) {
        this.log().debug("AddingSnapshot id:{} revision:{}", (Object)snapshot.streamId(), (Object)BoxesRunTime.boxToInteger((int)snapshot.streamRevision()));
        List<Commit> list = this.commits();
        synchronized (list) {
            Boolean bl;
            Option currentHead = this.heads().find((Function1)new Serializable(this, snapshot){
                public static final long serialVersionUID = 0L;
                private final Snapshot snapshot$1;

                public final boolean apply(StreamHead h) {
                    UUID uUID = h.streamId();
                    UUID uUID2 = this.snapshot$1.streamId();
                    return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
                }
                {
                    this.snapshot$1 = snapshot$1;
                }
            });
            if (currentHead.isDefined()) {
                StreamHead newhead = (StreamHead)currentHead.get();
                this.snapshots_$eq((List<Snapshot>)((List)this.snapshots().$colon$plus((Object)snapshot, List$.MODULE$.canBuildFrom())));
                this.heads_$eq(this.remove(newhead, this.heads()));
                this.heads_$eq((List<StreamHead>)((List)this.heads().$colon$plus((Object)new StreamHead(newhead.streamId(), newhead.headRevision(), snapshot.streamRevision()), List$.MODULE$.canBuildFrom())));
                bl = BoxesRunTime.boxToBoolean((boolean)true);
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)false);
            }
            Boolean bl2 = bl;
            return BoxesRunTime.unboxToBoolean((Object)bl2);
        }
    }

    @Override
    public void purge() {
        List<Commit> list = this.commits();
        synchronized (list) {
            this.commits_$eq((List<Commit>)Nil$.MODULE$);
            this.snapshots_$eq((List<Snapshot>)Nil$.MODULE$);
            this.heads_$eq((List<StreamHead>)Nil$.MODULE$);
            return;
        }
    }

    public <A> List<A> remove(A num, List<A> list) {
        return (List)list.diff((GenSeq)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{num})));
    }

    public InMemoryPersistenceEngine() {
        Logging$class.$init$(this);
        this.commits = Nil$.MODULE$;
        this.heads = Nil$.MODULE$;
        this.undispatched = Nil$.MODULE$;
        this.snapshots = Nil$.MODULE$;
        this.stamps = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

