/*
 * Decompiled with CFR 0.152.
 */
package CQRS;

import CQRS.AggregateRoot;
import CQRS.DomainEvent;
import CQRS.InventoryItemCreated;
import CQRS.InventoryItemDeactivated;
import CQRS.InventoryItemRenamed;
import CQRS.ItemsCheckedInToInventory;
import CQRS.ItemsRemovedFromInventory;
import java.util.UUID;
import scala.Function1;
import scala.PartialFunction;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u000b\ti\u0011J\u001c<f]R|'/_%uK6T\u0011aA\u0001\u0005\u0007F\u00136k\u0001\u0001\u0014\u0005\u00011\u0001CA\u0004\t\u001b\u0005\u0011\u0011BA\u0005\u0003\u00055\tum\u001a:fO\u0006$XMU8pi\")1\u0002\u0001C\u0001\u0019\u00051A(\u001b8jiz\"\u0012!\u0004\t\u0003\u000f\u0001Aqa\u0004\u0001A\u0002\u0013\u0005\u0001#A\u0005bGRLg/\u0019;fIV\t\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12CA\u0004C_>dW-\u00198\t\u000fa\u0001\u0001\u0019!C\u00013\u0005i\u0011m\u0019;jm\u0006$X\rZ0%KF$\"AG\u000f\u0011\u0005IY\u0012B\u0001\u000f\u0014\u0005\u0011)f.\u001b;\t\u000fy9\u0012\u0011!a\u0001#\u0005\u0019\u0001\u0010J\u0019\t\r\u0001\u0002\u0001\u0015)\u0003\u0012\u0003)\t7\r^5wCR,G\r\t\u0005\bE\u0001\u0001\r\u0011\"\u0001$\u0003\tIG-F\u0001%!\t)\u0003F\u0004\u0002\bM%\u0011qEA\u0001\ba\u0006\u001c7.Y4f\u0013\tI#F\u0001\u0003H+&#%BA\u0014\u0003\u0011\u001da\u0003\u00011A\u0005\u00025\na!\u001b3`I\u0015\fHC\u0001\u000e/\u0011\u001dq2&!AA\u0002\u0011Ba\u0001\r\u0001!B\u0013!\u0013aA5eA!)1\u0002\u0001C\u0001eQ\u0019QbM\u001b\t\u000bQ\n\u0004\u0019\u0001\u0013\u0002\u0007%$w\fC\u00037c\u0001\u0007q'A\u0003oC6,w\f\u0005\u00029w9\u0011!#O\u0005\u0003uM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!h\u0005\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007Q\u0006tG\r\\3\u0016\u0003\u0005\u0003BA\u0005\"E5%\u00111i\u0005\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0011q!R\u0005\u0003\r\n\u00111\u0002R8nC&tWI^3oi\")q\b\u0001C\u0001\u0011R\u0011!$\u0013\u0005\u0006\u0015\u001e\u0003\raS\u0001\u0002KB\u0011q\u0001T\u0005\u0003\u001b\n\u0011A#\u00138wK:$xN]=Ji\u0016l7I]3bi\u0016$\u0007\"B \u0001\t\u0003yEC\u0001\u000eQ\u0011\u0015Qe\n1\u0001R!\t9!+\u0003\u0002T\u0005\tA\u0012J\u001c<f]R|'/_%uK6$U-Y2uSZ\fG/\u001a3\t\u000bU\u0003A\u0011\u0001,\u0002\u0015\rD\u0017M\\4f\u001d\u0006lW\r\u0006\u0002\u001b/\")\u0001\f\u0016a\u0001o\u00059a.Z<OC6,\u0007\"\u0002.\u0001\t\u0003Y\u0016A\u0002:f[>4X\r\u0006\u0002\u001b9\")Q,\u0017a\u0001=\u0006)1m\\;oiB\u0011!cX\u0005\u0003AN\u00111!\u00138u\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u001d\u0019\u0007.Z2l\u0013:$\"A\u00073\t\u000bu\u000b\u0007\u0019\u00010\t\u000b\u0019\u0004A\u0011A4\u0002\u0015\u0011,\u0017m\u0019;jm\u0006$X\rF\u0001\u001b\u0001")
public class InventoryItem
extends AggregateRoot {
    private boolean activated = false;
    private UUID id = UUID.randomUUID();

    public boolean activated() {
        return this.activated;
    }

    public void activated_$eq(boolean x$1) {
        this.activated = x$1;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public void id_$eq(UUID x$1) {
        this.id = x$1;
    }

    @Override
    public PartialFunction<DomainEvent, BoxedUnit> handle() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InventoryItem $outer;

            public final <A1 extends DomainEvent, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InventoryItemCreated) {
                    InventoryItemCreated inventoryItemCreated = (InventoryItemCreated)A1;
                    this.$outer.handle(inventoryItemCreated);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof InventoryItemDeactivated) {
                    InventoryItemDeactivated inventoryItemDeactivated = (InventoryItemDeactivated)A1;
                    this.$outer.handle(inventoryItemDeactivated);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(DomainEvent x1) {
                DomainEvent domainEvent = x1;
                boolean bl = domainEvent instanceof InventoryItemCreated ? true : domainEvent instanceof InventoryItemDeactivated;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void handle(InventoryItemCreated e) {
        this.id_$eq(e.id());
        this.activated_$eq(true);
    }

    public void handle(InventoryItemDeactivated e) {
        this.activated_$eq(false);
    }

    public void changeName(String newName) {
        if (newName.isEmpty()) {
            throw new Exception("newName");
        }
        this.applyChange(new InventoryItemRenamed(this.id(), newName), this.applyChange$default$2());
    }

    public void remove(int count) {
        if (count <= 0) {
            throw new Exception("cant remove negative count from inventory");
        }
        this.applyChange(new ItemsRemovedFromInventory(this.id(), count), this.applyChange$default$2());
    }

    public void checkIn(int count) {
        if (count <= 0) {
            throw new Exception("must have a count greater than 0 to add to inventory");
        }
        this.applyChange(new ItemsCheckedInToInventory(this.id(), count), this.applyChange$default$2());
    }

    public void deactivate() {
        if (this.activated()) {
            this.applyChange(new InventoryItemDeactivated(this.id()), this.applyChange$default$2());
            return;
        }
        throw new Exception("already deactivated");
    }

    public InventoryItem() {
    }

    public InventoryItem(UUID id_, String name_) {
        this();
        this.applyChange(new InventoryItemCreated(id_, name_), this.applyChange$default$2());
    }
}

