/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.cqrs.example;

import java.util.UUID;
import net.glorat.cqrs.AggregateRoot;
import net.glorat.cqrs.AggregateRootState;
import net.glorat.cqrs.DomainEvent;
import net.glorat.cqrs.example.InventoryItem$;
import net.glorat.cqrs.example.InventoryItemCreated;
import net.glorat.cqrs.example.InventoryItemDeactivated;
import net.glorat.cqrs.example.InventoryItemRenamed;
import net.glorat.cqrs.example.InventoryItemState;
import net.glorat.cqrs.example.ItemsCheckedInToInventory;
import net.glorat.cqrs.example.ItemsRemovedFromInventory;
import scala.Function1;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ms!B\n\u0015\u0011\u0003ib!B\u0010\u0015\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0005\u0004%\tA\u000b\u0005\u0007?\u0006\u0001\u000b\u0011B\u0016\t\u000f\u0001\f!\u0019!C\u0001C\"1\u0001.\u0001Q\u0001\n\t4Aa\b\u000b\u0001S\")qe\u0002C\u0001U\"9An\u0002a\u0001\n#j\u0007bB9\b\u0001\u0004%\tF\u001d\u0005\u0007q\u001e\u0001\u000b\u0015\u00028\t\u000be<A\u0011\u0001>\t\u000by<A\u0011A@\t\r\u001d:A\u0011AA\u0011\u0011\u001d\tYd\u0002C\u0001\u0003{Aq!a\u0011\b\t\u0003\t)\u0005C\u0004\u0002R\u001d!\t!a\u0015\t\u000f\u0005]s\u0001\"\u0001\u0002Z\u0005i\u0011J\u001c<f]R|'/_%uK6T!!\u0006\f\u0002\u000f\u0015D\u0018-\u001c9mK*\u0011q\u0003G\u0001\u0005GF\u00148O\u0003\u0002\u001a5\u00051q\r\\8sCRT\u0011aG\u0001\u0004]\u0016$8\u0001\u0001\t\u0003=\u0005i\u0011\u0001\u0006\u0002\u000e\u0013:4XM\u001c;pefLE/Z7\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005i\u0011\r\u001c7Fm\u0016tG\u000fV=qKN,\u0012a\u000b\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013!C5n[V$\u0018M\u00197f\u0015\t\u00014%\u0001\u0006d_2dWm\u0019;j_:L!AM\u0017\u0003\t1K7\u000f\u001e\u0019\u0003iy\u00022!\u000e\u001e=\u001b\u00051$BA\u001c9\u0003\u0011a\u0017M\\4\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0006\u00072\f7o\u001d\t\u0003{yb\u0001\u0001B\u0005@\u0001\u0005\u0005\t\u0011!B\u0001\u0001\n\u0011q,M\t\u0003\u0003N\u0013bA\u0011#H\u00156\u0003f\u0001B\"\u0001\u0001\u0005\u0013A\u0002\u0010:fM&tW-\\3oiz\u0002\"AH#\n\u0005\u0019#\"!G%uK6\u001c(+Z7pm\u0016$gI]8n\u0013:4XM\u001c;pef\u0004\"A\b%\n\u0005%#\"!G%uK6\u001c8\t[3dW\u0016$\u0017J\u001c+p\u0013:4XM\u001c;pef\u0004\"AH&\n\u00051#\"\u0001G%om\u0016tGo\u001c:z\u0013R,W\u000eR3bGRLg/\u0019;fIB\u0011aDT\u0005\u0003\u001fR\u0011A#\u00138wK:$xN]=Ji\u0016l'+\u001a8b[\u0016$\u0007C\u0001\u0010R\u0013\t\u0011FC\u0001\u000bJ]Z,g\u000e^8ss&#X-\\\"sK\u0006$X\r\u001a\n\u0004)VKf\u0001B\"\u0001\u0001M\u0003\"AV,\u000e\u0003YI!\u0001\u0017\f\u0003\u0017\u0011{W.Y5o\u000bZ,g\u000e\u001e\t\u00035vk\u0011a\u0017\u0006\u00039b\n!![8\n\u0005y[&\u0001D*fe&\fG.\u001b>bE2,\u0017AD1mY\u00163XM\u001c;UsB,7\u000fI\u0001\te\u0016<\u0017n\u001d;ssV\t!\r\u0005\u0003#GV+\u0017B\u00013$\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002WM&\u0011qM\u0006\u0002\u000e\u0003\u001e<'/Z4bi\u0016\u0014vn\u001c;\u0002\u0013I,w-[:uef\u00043CA\u0004f)\u0005Y\u0007C\u0001\u0010\b\u0003\u0015\u0019H/\u0019;f+\u0005q\u0007C\u0001,p\u0013\t\u0001hC\u0001\nBO\u001e\u0014XmZ1uKJ{w\u000e^*uCR,\u0017!C:uCR,w\fJ3r)\t\u0019h\u000f\u0005\u0002#i&\u0011Qo\t\u0002\u0005+:LG\u000fC\u0004x\u0015\u0005\u0005\t\u0019\u00018\u0002\u0007a$\u0013'\u0001\u0004ti\u0006$X\rI\u0001\tO\u0016$8\u000b^1uKV\t1\u0010\u0005\u0002\u001fy&\u0011Q\u0010\u0006\u0002\u0013\u0013:4XM\u001c;pefLE/Z7Ti\u0006$X-\u0001\u0002jIV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tYB\u0004\u0003\u0002\u0006\u0005]a\u0002BA\u0004\u0003+qA!!\u0003\u0002\u00149!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010q\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005eQ\u0012BA\f\u0019\u0013\r\tIBF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti\"a\b\u0003\t\u001d+\u0016\n\u0012\u0006\u0004\u000331B#B6\u0002$\u0005\u001d\u0002bBA\u0013\u001d\u0001\u0007\u0011\u0011A\u0001\u0004S\u0012|\u0006bBA\u0015\u001d\u0001\u0007\u00111F\u0001\u0006]\u0006lWm\u0018\t\u0005\u0003[\t)D\u0004\u0003\u00020\u0005E\u0002cAA\u0006G%\u0019\u00111G\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019dI\u0001\u000bG\"\fgnZ3OC6,GcA:\u0002@!9\u0011\u0011I\bA\u0002\u0005-\u0012a\u00028fo:\u000bW.Z\u0001\u0007e\u0016lwN^3\u0015\u0007M\f9\u0005C\u0004\u0002JA\u0001\r!a\u0013\u0002\u000b\r|WO\u001c;\u0011\u0007\t\ni%C\u0002\u0002P\r\u00121!\u00138u\u0003\u001d\u0019\u0007.Z2l\u0013:$2a]A+\u0011\u001d\tI%\u0005a\u0001\u0003\u0017\n!\u0002Z3bGRLg/\u0019;f)\u0005\u0019\b")
public class InventoryItem
extends AggregateRoot {
    private AggregateRootState state = new InventoryItemState(UUID.randomUUID(), false);

    public static Function1<DomainEvent, AggregateRoot> registry() {
        return InventoryItem$.MODULE$.registry();
    }

    public static List<Class<? extends DomainEvent>> allEventTypes() {
        return InventoryItem$.MODULE$.allEventTypes();
    }

    @Override
    public AggregateRootState state() {
        return this.state;
    }

    @Override
    public void state_$eq(AggregateRootState x$1) {
        this.state = x$1;
    }

    @Override
    public InventoryItemState getState() {
        return (InventoryItemState)this.state();
    }

    @Override
    public UUID id() {
        return this.getState().id();
    }

    public void changeName(String newName) {
        if (newName.isEmpty()) {
            throw new Exception("newName");
        }
        this.applyChange(new InventoryItemRenamed(this.id(), newName), this.applyChange$default$2());
    }

    public void remove(int count) {
        if (count <= 0) {
            throw new Exception("cant remove negative count from inventory");
        }
        this.applyChange(new ItemsRemovedFromInventory(this.id(), count), this.applyChange$default$2());
    }

    public void checkIn(int count) {
        if (count <= 0) {
            throw new Exception("must have a count greater than 0 to add to inventory");
        }
        this.applyChange(new ItemsCheckedInToInventory(this.id(), count), this.applyChange$default$2());
    }

    public void deactivate() {
        if (!this.getState().activated()) {
            throw new Exception("already deactivated");
        }
        this.applyChange(new InventoryItemDeactivated(this.id()), this.applyChange$default$2());
    }

    public InventoryItem() {
    }

    public InventoryItem(UUID id_, String name_) {
        this();
        this.applyChange(new InventoryItemCreated(id_, name_), this.applyChange$default$2());
    }
}

