/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.dlcrypto.mock;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import net.glorat.dlcrypto.core.Hash;
import net.glorat.dlcrypto.core.PrivateKeyExtProvider;
import net.glorat.dlcrypto.core.PublicKeyExtProvider;
import net.glorat.dlcrypto.core.Signature;
import net.glorat.dlcrypto.core.Signer;
import net.glorat.dlcrypto.core.package$;
import net.glorat.dlcrypto.mock.MockPrivateKey;
import net.glorat.dlcrypto.mock.MockPrivateKeyProvider;
import net.glorat.dlcrypto.mock.MockPublicKey;
import net.glorat.dlcrypto.mock.MockPublicKeyProvider;
import net.glorat.dlcrypto.mock.MockSignature;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;

public final class MockCrypto$
implements Signer {
    public static MockCrypto$ MODULE$;
    private final SecureRandom secureRandom;

    static {
        new MockCrypto$();
    }

    public PrivateKey createSigningKeyFromHex(String key) {
        return Signer.createSigningKeyFromHex$((Signer)this, (String)key);
    }

    public PublicKey createVerificationKeyFromHex(String key) {
        return Signer.createVerificationKeyFromHex$((Signer)this, (String)key);
    }

    public Signature sign(Hash data, PrivateKey key) {
        return Signer.sign$((Signer)this, (Hash)data, (PrivateKey)key);
    }

    public Signature sign(Hash data, byte[] keyBytes) {
        return Signer.sign$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public byte[] signToBytes(Hash data, byte[] keyBytes) {
        return Signer.signToBytes$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public boolean verify(Hash data, Seq<Object> sig, Seq<Object> identity) {
        return Signer.verify$((Signer)this, (Hash)data, sig, identity);
    }

    public boolean verify(Hash data, Signature sig, PublicKey identity) {
        return Signer.verify$((Signer)this, (Hash)data, (Signature)sig, (PublicKey)identity);
    }

    public SecureRandom secureRandom() {
        return this.secureRandom;
    }

    public String providerName() {
        return "Mock";
    }

    public boolean verify(byte[] message, Signature sig, PublicKey identity) {
        Predef$.MODULE$.require(sig instanceof MockSignature, (Function0 & Serializable & scala.Serializable)() -> "Signature must be a MockSignature");
        String idstr = new String(package$.MODULE$.PublicKeyExt(identity).getBytes());
        String sigstr = ((MockSignature)sig).sig();
        return sigstr.equals(new StringBuilder(10).append("Signed by ").append(idstr).toString());
    }

    public boolean handlesPrivateKey(PrivateKey key) {
        return key instanceof MockPrivateKey;
    }

    public boolean handlesPublicKey(PublicKey key) {
        return key instanceof MockPublicKey;
    }

    public PublicKeyExtProvider publicKeyExtProvider(PublicKey key) {
        return new MockPublicKeyProvider(key);
    }

    public PublicKey inferPublicKey(PrivateKey priv) {
        return new MockPublicKey(((MockPrivateKey)priv).name());
    }

    public KeyPair generate() {
        return this.generate(this.secureRandom());
    }

    public KeyPair generate(SecureRandom rng) {
        String string;
        int ran;
        int n = ran = rng.nextInt() % 2;
        switch (n) {
            case 0: {
                string = "Ana";
                break;
            }
            case 1: {
                string = "Barry";
                break;
            }
            default: {
                string = "Someone";
                break;
            }
        }
        String id = string;
        MockPrivateKey priv = new MockPrivateKey(id);
        MockPublicKey pub = new MockPublicKey(id);
        return new KeyPair(pub, priv);
    }

    public PublicKey createVerificationKey(byte[] data) {
        return new MockPublicKey(new String(data));
    }

    public Signature sign(byte[] message, PrivateKey key) {
        PrivateKey privateKey = key;
        if (!(privateKey instanceof MockPrivateKey)) {
            throw new IllegalArgumentException(new StringBuilder(17).append("Unknown key type ").append(key.getClass().getName()).toString());
        }
        MockPrivateKey mockPrivateKey = (MockPrivateKey)privateKey;
        String string = mockPrivateKey.name();
        String id = string;
        return new MockSignature(new StringBuilder(10).append("Signed by ").append(id).toString());
    }

    public PrivateKeyExtProvider privateKeyExtProvider(PrivateKey key) {
        return new MockPrivateKeyProvider(key);
    }

    public Signature createSignature(byte[] data) {
        return new MockSignature(new String(data));
    }

    public PrivateKey createSigningKey(byte[] data) {
        return new MockPrivateKey(new String(data));
    }

    private MockCrypto$() {
        MODULE$ = this;
        Signer.$init$((Signer)this);
        this.secureRandom = new SecureRandom();
    }
}

