/*
 * Decompiled with CFR 0.152.
 */
package net.glorat.dlcrypto.ecdsa;

import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import net.glorat.dlcrypto.core.Hash;
import net.glorat.dlcrypto.core.Signature;
import net.glorat.dlcrypto.core.Signer;
import net.glorat.dlcrypto.ecdsa.ECDSASignature;
import net.glorat.dlcrypto.ecdsa.ECDSASignature$;
import net.glorat.dlcrypto.ecdsa.ECDSASignerBitcoin;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ECDSASignerBitcoin$
implements Signer {
    public static ECDSASignerBitcoin$ MODULE$;
    private final String providerName;
    private final String algorithmName;
    private final ECGenParameterSpec ecGenSpec;
    private final ECNamedCurveParameterSpec ecSpec;
    private final X9ECParameters params;
    private final ECDomainParameters ecDomainParameters;
    private final SecureRandom secureRandom;
    private final KeyPairGenerator generator;
    private final KeyFactory keyFactory;

    static {
        new ECDSASignerBitcoin$();
    }

    public PrivateKey createSigningKeyFromHex(String key) {
        return Signer.createSigningKeyFromHex$((Signer)this, (String)key);
    }

    public PublicKey createVerificationKeyFromHex(String key) {
        return Signer.createVerificationKeyFromHex$((Signer)this, (String)key);
    }

    public Signature sign(Hash data, PrivateKey key) {
        return Signer.sign$((Signer)this, (Hash)data, (PrivateKey)key);
    }

    public Signature sign(Hash data, byte[] keyBytes) {
        return Signer.sign$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public byte[] signToBytes(Hash data, byte[] keyBytes) {
        return Signer.signToBytes$((Signer)this, (Hash)data, (byte[])keyBytes);
    }

    public boolean verify(Hash data, Seq<Object> sig, Seq<Object> identity) {
        return Signer.verify$((Signer)this, (Hash)data, sig, identity);
    }

    public boolean verify(Hash data, Signature sig, PublicKey identity) {
        return Signer.verify$((Signer)this, (Hash)data, (Signature)sig, (PublicKey)identity);
    }

    public String providerName() {
        return this.providerName;
    }

    public String algorithmName() {
        return this.algorithmName;
    }

    public ECGenParameterSpec ecGenSpec() {
        return this.ecGenSpec;
    }

    public ECNamedCurveParameterSpec ecSpec() {
        return this.ecSpec;
    }

    public X9ECParameters params() {
        return this.params;
    }

    private ECDomainParameters ecDomainParameters() {
        return this.ecDomainParameters;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private KeyPairGenerator generator() {
        return this.generator;
    }

    private KeyFactory keyFactory() {
        return this.keyFactory;
    }

    public boolean handlesPublicKey(PublicKey key) {
        return key instanceof BCECPublicKey || key instanceof JCEECPublicKey || key instanceof ECPublicKey;
    }

    public boolean handlesPrivateKey(PrivateKey key) {
        return key instanceof BCECPrivateKey || key instanceof JCEECPrivateKey;
    }

    public ECDSASignerBitcoin.MyPrivateKey privateKeyExtProvider(PrivateKey priv) {
        return new ECDSASignerBitcoin.MyPrivateKey(priv);
    }

    public ECDSASignerBitcoin.SigningKey publicKeyExtProvider(PublicKey pub) {
        return new ECDSASignerBitcoin.SigningKey(pub);
    }

    public PrivateKey createSigningKey(byte[] data) {
        PrivateKey privateKey;
        BigInteger bigInt = package$.MODULE$.BigInt().apply(1, data).bigInteger();
        ECPrivateKeySpec priKeySpec = new ECPrivateKeySpec(bigInt, (ECParameterSpec)this.ecSpec());
        try {
            privateKey = this.keyFactory().generatePrivate((KeySpec)priKeySpec);
        }
        catch (Throwable throwable) {
            Exception exception;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Exception && (exception = (Exception)throwable2).toString().contains("key spec not recognised")) {
                String actual = this.fromWhere(priKeySpec);
                String expected = this.fromWhere(this.generate(this.secureRandom()).getPrivate());
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("My supposedly bad key spec comes from ").append(actual).toString());
                Predef$.MODULE$.println((Object)new StringBuilder(20).append("Expected source was ").append(expected).toString());
                throw exception;
            }
            throw throwable;
        }
        return privateKey;
    }

    private String fromWhere(Object o) {
        String name;
        URL resource;
        Predef$.MODULE$.require(o != null);
        Class<?> c = o.getClass();
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        return loader != null ? ((resource = loader.getResource(new StringBuilder(6).append((name = c.getCanonicalName()).replace(".", "/")).append(".class").toString())) != null ? resource.toString() : "Unknown - no resource") : "Unknown - no loader";
    }

    public PublicKey createVerificationKey(byte[] pub) {
        ECPoint eCPoint;
        try {
            eCPoint = this.ecDomainParameters().getCurve().decodePoint(pub);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid public key: ").append(net.glorat.dlcrypto.core.package$.MODULE$.bytesToHexString(pub)).toString());
        }
        catch (Exception e) {
            throw new Exception(new StringBuilder(31).append("Unknown issue with public key: ").append(net.glorat.dlcrypto.core.package$.MODULE$.bytesToHexString(pub)).toString(), e);
        }
        ECPoint pt = eCPoint;
        ECPublicKeySpec foo = new ECPublicKeySpec(pt, (ECParameterSpec)this.ecSpec());
        return this.keyFactory().generatePublic((KeySpec)foo);
    }

    public PublicKey inferPublicKey(PrivateKey priv) {
        BigInteger bigInteger;
        PrivateKey privateKey = priv;
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey bCECPrivateKey = (BCECPrivateKey)privateKey;
            bigInteger = bCECPrivateKey.getD();
        } else if (privateKey instanceof JCEECPrivateKey) {
            JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)privateKey;
            bigInteger = jCEECPrivateKey.getD();
        } else {
            throw new Exception(new StringBuilder(33).append("Don't recognise private key type ").append(priv.getClass()).toString());
        }
        BigInteger d = bigInteger;
        if (BoxesRunTime.equalsNumNum((Number)d, (Number)BigInteger.ZERO)) {
            throw new IllegalArgumentException("PrivateKey invalid");
        }
        ECPoint q = this.params().getG().multiply(d);
        ECPublicKeySpec spec = new ECPublicKeySpec(q, (ECParameterSpec)this.ecSpec());
        return this.keyFactory().generatePublic((KeySpec)spec);
    }

    public Signature createSignature(byte[] data) {
        return ECDSASignature$.MODULE$.decodeFromDER(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(byte[] data, Signature sig, PublicKey identity) {
        Signature signature = sig;
        if (!(signature instanceof ECDSASignature)) return false;
        ECDSASignature eCDSASignature = (ECDSASignature)signature;
        if (!(identity instanceof BCECPublicKey)) return false;
        BCECPublicKey pubkey = (BCECPublicKey)identity;
        ECPoint pubpt = pubkey.getQ();
        ECDSASigner signer = new ECDSASigner();
        ECPublicKeyParameters params = new ECPublicKeyParameters(this.ecDomainParameters().getCurve().decodePoint(net.glorat.dlcrypto.core.package$.MODULE$.PublicKeyExt((PublicKey)pubkey).getBytes()), this.ecDomainParameters());
        signer.init(false, (CipherParameters)params);
        try {
            boolean bl = signer.verifySignature(data, eCDSASignature.r(), eCDSASignature.s());
            return bl;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)"Caught NPE inside bouncy castle");
            e.printStackTrace();
            return false;
        }
    }

    public ECDSASignature sign(byte[] data, PrivateKey priv) {
        BigInteger bigInteger;
        PrivateKey privateKey = priv;
        if (privateKey instanceof BCECPrivateKey) {
            BCECPrivateKey bCECPrivateKey = (BCECPrivateKey)privateKey;
            bigInteger = bCECPrivateKey.getD();
        } else if (privateKey instanceof JCEECPrivateKey) {
            JCEECPrivateKey jCEECPrivateKey = (JCEECPrivateKey)privateKey;
            bigInteger = jCEECPrivateKey.getD();
        } else {
            throw new Exception(new StringBuilder(33).append("Don't recognise private key type ").append(priv.getClass()).toString());
        }
        BigInteger d = bigInteger;
        ECDSASigner signer = new ECDSASigner();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(d, this.ecDomainParameters());
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(data);
        ECDSASignature x = new ECDSASignature(components[0], components[1]).ensureCanonical();
        return x;
    }

    public KeyPair generate() {
        return this.generate(this.secureRandom());
    }

    /*
     * WARNING - void declaration
     */
    public KeyPair generate(SecureRandom rng) {
        void var3_3;
        KeyPairGenerator g = KeyPairGenerator.getInstance(this.algorithmName(), this.providerName());
        g.initialize(this.ecGenSpec(), rng);
        KeyPair pair = g.generateKeyPair();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] net$glorat$dlcrypto$ecdsa$ECDSASignerBitcoin$$bigIntegerToBytes(BigInt b, int numBytes) {
        void var3_3;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(numBytes, ClassTag$.MODULE$.Byte());
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return var3_3;
    }

    private ECDSASignerBitcoin$() {
        MODULE$ = this;
        Signer.$init$((Signer)this);
        this.providerName = "BC";
        this.algorithmName = "ECDSA";
        this.ecGenSpec = new ECGenParameterSpec("secp256k1");
        this.ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        this.params = SECNamedCurves.getByName((String)"secp256k1");
        this.ecDomainParameters = new ECDomainParameters(this.params().getCurve(), this.params().getG(), this.params().getN(), this.params().getH());
        this.secureRandom = new SecureRandom();
        this.generator = KeyPairGenerator.getInstance(this.algorithmName(), this.providerName());
        this.keyFactory = KeyFactory.getInstance(this.algorithmName(), this.providerName());
    }
}

