/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;

public class Utils {
    private Utils() {
    }

    public static InputStream getInputStream(String filename) throws FileNotFoundException {
        InputStream in = new File(filename).exists() ? new FileInputStream(filename) : Utils.class.getResourceAsStream("/" + filename);
        if (in == null) {
            throw new FileNotFoundException(filename);
        }
        return new BufferedInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] buf = new byte[4096];
            while ((read = in.read(buf)) > -1) {
                out.write(buf, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String[] readLines(File file) throws IOException {
        return Utils.readLines(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            in.close();
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static long readVarint(InputStream in) throws IOException {
        int b;
        long val = 0L;
        int bits = 0;
        do {
            b = in.read();
            val |= (long)((b & 0x7F) << bits);
            bits += 7;
            if (b >= 0) continue;
            throw new EOFException("unexpected end of stream");
        } while ((b & 0xFFFFFF80) != 0);
        return val;
    }

    public static void writeVarint(OutputStream out, long val) throws IOException {
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)(val | 0x80L));
            val >>>= 7;
        }
        out.write((int)val);
    }

    public static StringBuilder append(StringBuilder sb, byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() == 1) {
            sb.append('0');
        }
        return sb.append(s);
    }

    public static StringBuilder append(StringBuilder sb, byte[] bytes, int offset, int length) {
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            Utils.append(sb, bytes[offset + i]).append(' ');
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb;
    }
}

