/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import net.freeutils.scrollphat.Device;

public class Pi4JDevice
extends Device {
    protected I2CBus bus;
    protected I2CDevice device;

    protected Device openImpl(int busNumber, int address) throws IOException {
        try {
            this.bus = I2CFactory.getInstance((int)busNumber);
            this.device = this.bus.getDevice(address);
        }
        catch (I2CFactory.UnsupportedBusNumberException ubne) {
            throw new IOException("error getting I2C bus: " + (Object)((Object)ubne));
        }
        return this;
    }

    protected void closeImpl() throws IOException {
        if (this.device != null) {
            this.reset();
        }
        this.device = null;
        if (this.bus != null) {
            this.bus.close();
        }
        this.bus = null;
    }

    protected void writeImpl(byte register, int data) throws IOException {
        this.device.write((int)register, (byte)data);
    }

    protected void writeImpl(byte register, byte[] data, int offset, int length) throws IOException {
        this.device.write((int)register, data, offset, length);
    }
}

