/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.IOException;
import net.freeutils.scrollphat.Canvas;
import net.freeutils.scrollphat.Device;
import net.freeutils.scrollphat.Utils;

public class MockDevice
extends Device {
    byte[] registers = new byte[256];

    protected Device openImpl(int busNumber, int address) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        sb.append("opening device on bus #").append(busNumber).append(" at address 0x");
        Utils.append(sb, (byte)address);
        System.out.println(sb);
        return this;
    }

    protected void closeImpl() {
        System.out.println("closing device");
    }

    protected void writeImpl(byte register, byte[] data, int offset, int length) throws IOException {
        System.arraycopy(data, offset, this.registers, register & 0xFF, length);
        StringBuilder sb = new StringBuilder(32);
        sb.append("writing to register 0x");
        Utils.append(sb, register).append(": ");
        Utils.append(sb, data, offset, length);
        System.out.println(sb);
    }

    public void update() throws IOException {
        String art = Canvas.toAsciiArt(this.registers, 1, this.getWidth(), this.getHeight());
        System.out.println(art);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new MockDevice().init().displayTestPatterns();
    }
}

