/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.freeutils.scrollphat.Canvas;
import net.freeutils.scrollphat.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LEDFont {
    public static byte[] MAGIC = new byte[]{76, 69, 68, 83};
    protected int height;
    protected byte[] data;
    protected int used;
    protected Map<Integer, Integer> lookup;

    protected LEDFont(int height) {
        this.height = height;
        this.data = new byte[1024];
        this.lookup = new HashMap<Integer, Integer>(256);
    }

    public LEDFont(String filename) throws IOException {
        try {
            this.parse(Utils.readBytes(Utils.getInputStream(filename)));
        }
        catch (FileNotFoundException fnfe) {
            this.parse(Utils.readBytes(Utils.getInputStream(filename + ".ledfont")));
        }
    }

    public LEDFont(InputStream in) throws IOException {
        this(Utils.readBytes(in));
    }

    public LEDFont(byte[] data) {
        this.parse(data);
    }

    public int getHeight() {
        return this.height;
    }

    public Set<Integer> getSupportedChars() {
        return new TreeSet<Integer>(this.lookup.keySet());
    }

    public String getSupportedCharsAsString() {
        Set<Integer> chars = this.getSupportedChars();
        StringBuilder sb = new StringBuilder(chars.size());
        for (int c : chars) {
            sb.appendCodePoint(c);
        }
        return sb.toString();
    }

    protected void parse(byte[] data) {
        byte version;
        int i;
        for (i = 0; i < MAGIC.length; ++i) {
            if (data.length > i && data[i] == MAGIC[i]) continue;
            throw new IllegalArgumentException("invalid header at position " + i);
        }
        int headerLen = data[i++] & 0xFF;
        if ((version = data[i++]) != 1) {
            throw new IllegalArgumentException("invalid font format version " + version);
        }
        this.height = data[i++] & 0xFF;
        i += headerLen - 2;
        HashMap<Integer, Integer> lookup = new HashMap<Integer, Integer>(256);
        while (i < data.length) {
            int width;
            if (i + 3 > data.length) {
                throw new IllegalArgumentException("data is corrupt at position " + i);
            }
            int c = data[i++] & 0xFF | (data[i++] & 0xFF) << 8 | (data[i++] & 0xFF) << 16;
            if (i + (width = data[i++] & 0xFF) > data.length) {
                throw new IllegalArgumentException("data is corrupt at position " + (i - 1));
            }
            lookup.put(c, i - 1);
            i += width;
        }
        this.data = data;
        this.used = data.length;
        this.lookup = lookup;
    }

    protected void save(OutputStream out) throws IOException {
        out.write(MAGIC);
        out.write(2);
        out.write(1);
        out.write(this.height);
        for (Integer codePoint : this.getSupportedChars()) {
            Integer i = this.lookup.get(codePoint);
            int width = this.data[i] & 0xFF;
            out.write(codePoint);
            out.write(codePoint >> 8);
            out.write(codePoint >> 16);
            out.write(width);
            out.write(this.data, i + 1, width);
        }
    }

    protected void save(File out) throws IOException {
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(out));
            this.save(os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public int getMaxWidth(char[] chars) {
        int c;
        int max = 0;
        for (int i = 0; i < chars.length; i += Character.charCount(c)) {
            c = Character.codePointAt(chars, i);
            if (this.getWidth(c) <= max) continue;
            max = this.getWidth(c);
        }
        return max;
    }

    protected void addChar(int c, byte[] data, int offset, int length) {
        if (this.used + length + 1 >= this.data.length) {
            byte[] temp = new byte[this.data.length * 2];
            System.arraycopy(this.data, 0, temp, 0, this.used);
            this.data = temp;
        }
        this.lookup.put(c, this.used);
        this.data[this.used++] = (byte)length;
        System.arraycopy(data, offset, this.data, this.used, length);
        this.used += length;
    }

    public int getWidth(int c) {
        Integer i = this.lookup.get(c);
        return i == null ? 0 : this.data[i] & 0xFF;
    }

    public int getWidth(char[] chars, int start, int len) {
        int c;
        int width = 0;
        int end = start + len;
        for (int i = start; i < end; i += Character.charCount(c)) {
            c = Character.codePointAt(chars, i, end);
            width += this.getWidth(c);
        }
        return width;
    }

    public int getWidth(String s) {
        int c;
        int width = 0;
        int end = s.length();
        for (int i = 0; i < end; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            width += this.getWidth(c);
        }
        return width;
    }

    public int write(int c, byte[] buf, int offset) {
        Integer i = this.lookup.get(c);
        if (i == null) {
            return 0;
        }
        int width = this.data[i] & 0xFF;
        System.arraycopy(this.data, i + 1, buf, offset, width);
        return width;
    }

    public int write(char[] chars, int start, int len, byte[] buf, int offset) {
        int c;
        int width = 0;
        int end = start + len;
        for (int i = start; i < end; i += Character.charCount(c)) {
            c = Character.codePointAt(chars, i, end);
            width += this.write(c, buf, offset + width);
        }
        return width;
    }

    public int write(String s, byte[] buf, int offset) {
        int c;
        int width = 0;
        int len = s.length();
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            width += this.write(c, buf, offset + width);
        }
        return width;
    }

    public byte[] write(String s) {
        int width = this.getWidth(s);
        byte[] buf = new byte[width];
        this.write(s, buf, 0);
        return buf;
    }

    public String toAsciiArt(String s, int lineWidth) {
        int c;
        int len = s.length();
        int width = 0;
        StringBuilder sb = new StringBuilder(len);
        int j = 0;
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if ((width += this.getWidth(c)) < lineWidth) continue;
            String line = s.substring(j, i);
            String art = Canvas.toAsciiArt(this.write(line), this.getHeight());
            sb.append(art).append('\n');
            width = this.getWidth(c);
            j = i;
        }
        String line = s.substring(j, len);
        String art = Canvas.toAsciiArt(this.write(line), this.getHeight());
        sb.append(art).append('\n');
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        String text;
        if (args.length == 0) {
            System.out.println("Usage: LEDFont <filename> [text]");
            System.exit(-1);
        }
        LEDFont font = new LEDFont(args[0]);
        if (args.length > 1) {
            text = args[1];
        } else {
            text = font.getSupportedCharsAsString();
            System.out.println("Supported chars: [" + text + "]");
        }
        System.out.println(font.toAsciiArt(text, 80));
    }
}

