/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import net.freeutils.scrollphat.Device;

public class JNADevDevice
extends Device {
    protected FileOutputStream out;
    protected byte[] buf = new byte[257];

    protected int getNativeFileDescriptor(FileDescriptor fd) throws IOException {
        try {
            Field field = FileDescriptor.class.getDeclaredField("fd");
            field.setAccessible(true);
            return (Integer)field.get(fd);
        }
        catch (Exception e) {
            throw new IOException("error getting native file descriptor: " + e);
        }
    }

    protected void ioctl(int fd, int request, int data) throws IOException {
        try {
            Object[] args = new Object[]{fd, request, data};
            NativeLibrary library = NativeLibrary.getInstance((String)Platform.C_LIBRARY_NAME);
            int res = library.getFunction("ioctl").invokeInt(args);
            if (res != 0) {
                throw new IOException("ioctl returned " + res);
            }
        }
        catch (Throwable t) {
            throw new IOException("error invoking ioctl: " + t);
        }
    }

    protected Device openImpl(int busNumber, int address) throws IOException {
        this.out = new FileOutputStream("/dev/i2c-" + busNumber);
        int fd = this.getNativeFileDescriptor(this.out.getFD());
        this.ioctl(fd, 1795, address);
        return this;
    }

    protected void closeImpl() throws IOException {
        if (this.out != null) {
            this.reset();
            this.out.close();
            this.out = null;
        }
    }

    protected void writeImpl(byte register, int data) throws IOException {
        this.buf[0] = register;
        this.buf[1] = (byte)data;
        this.out.write(this.buf, 0, 2);
    }

    protected void writeImpl(byte register, byte[] data, int offset, int length) throws IOException {
        if (length >= this.buf.length) {
            this.buf = new byte[length + 1];
        }
        this.buf[0] = register;
        System.arraycopy(data, offset, this.buf, 1, length);
        this.out.write(this.buf, 0, length + 1);
    }
}

