/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.freeutils.scrollphat.LEDFont;
import net.freeutils.scrollphat.Utils;

public class FontConverter {
    public static Font loadTTF(String filename) throws IOException {
        InputStream in = null;
        try {
            in = Utils.getInputStream(filename);
            Font font = Font.createFont(0, in);
            return font;
        }
        catch (FontFormatException ffe) {
            throw new IOException(ffe.toString());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    static void convertPixels(byte[] out, BufferedImage image, int baseline, int width, int height) throws IOException {
        int imageHeight = image.getHeight();
        for (int col = 0; col < width; ++col) {
            byte b = 0;
            for (int row = 0; row < height; ++row) {
                int rgb;
                int y = baseline - height + row;
                if (y < 0 || y >= imageHeight || (rgb = image.getRGB(col, y) & 0xFFFFFF) == 0) continue;
                b = (byte)(b | 1 << row);
            }
            out[col] = b;
        }
    }

    public static LEDFont convert(Font font, int height, int offset) throws IOException {
        int imageWidth = height * 4;
        int imageHeight = height * 4;
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics g = image.getGraphics();
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics();
        int baseline = metrics.getAscent();
        if (baseline == 0) {
            baseline = height;
        }
        LEDFont ledfont = new LEDFont(height);
        char[] chars = new char[2];
        byte[] buf = new byte[256];
        for (int c = 0; c <= 0x10FFFF; ++c) {
            if (!font.canDisplay(c)) continue;
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, imageWidth, imageHeight);
            g.setColor(Color.WHITE);
            int charCount = Character.toChars(c, chars, 0);
            g.drawChars(chars, 0, charCount, 0, baseline);
            Rectangle2D bounds = metrics.getStringBounds(chars, 0, charCount, g);
            int width = (int)bounds.getWidth();
            if (width <= 0) continue;
            FontConverter.convertPixels(buf, image, baseline - offset, width, height);
            ledfont.addChar(c, buf, 0, width);
        }
        g.dispose();
        return ledfont;
    }

    public static void convert(Font font, int height, int offset, File out) throws IOException {
        FontConverter.convert(font, height, offset).save(out);
    }

    public static LEDFont parsePython(InputStream in, int height) throws IOException {
        String script = new String(Utils.readBytes(in), "UTF-8");
        Matcher matcher = Pattern.compile("\\{(\\s*(\\d+)\\s*:\\s*\\[([\\s\\d,]*)\\][\\s,]*)*\\}").matcher(script);
        if (!matcher.find()) {
            throw new IOException("invalid python font definition");
        }
        script = matcher.group().replaceAll("\\s", "");
        LEDFont ledfont = new LEDFont(height);
        byte[] buf = new byte[256];
        ledfont.addChar(32, buf, 0, 3);
        matcher = Pattern.compile("\\s*(\\d+)\\s*:\\s*\\[([\\s\\d,]*)\\][\\s,]*").matcher(script);
        while (matcher.find()) {
            int codePoint = Integer.parseInt(matcher.group(1));
            String data = matcher.group(2).replace("\\s", "");
            if (data.length() <= 0) continue;
            String[] cols = data.split(",");
            int len = cols.length;
            for (int i = 0; i < len; ++i) {
                buf[i] = Byte.parseByte(cols[i]);
            }
            buf[len++] = 0;
            ledfont.addChar(codePoint, buf, 0, len);
        }
        return ledfont;
    }

    public static void convertFromPython(File in, int height, File out) throws IOException {
        FontConverter.parsePython(new FileInputStream(in), height).save(out);
    }

    public static void main(String[] args) throws IOException {
        String in = null;
        File out = null;
        float points = 8.0f;
        int height = 5;
        int offset = 0;
        boolean dump = false;
        String text = null;
        int i = 0;
        block9: while (i < args.length) {
            String arg = args[i++];
            if (i == args.length || arg.length() < 2 || arg.charAt(0) != '-') {
                throw new IllegalArgumentException("invalid argument: " + arg);
            }
            String val = args[i++];
            switch (arg.charAt(1)) {
                case 'i': {
                    in = val;
                    continue block9;
                }
                case 'o': {
                    out = new File(val);
                    continue block9;
                }
                case 'p': {
                    points = Float.parseFloat(val);
                    continue block9;
                }
                case 'h': {
                    height = Integer.parseInt(val);
                    continue block9;
                }
                case 'f': {
                    offset = Integer.parseInt(val);
                    continue block9;
                }
                case 't': {
                    text = val;
                    continue block9;
                }
                case 'd': {
                    dump = val.equals("true");
                    continue block9;
                }
            }
            throw new IllegalArgumentException("invalid argument: " + arg);
        }
        if (in == null) {
            System.out.println("Usage: FontConverter -i input [-o output] [-p points] [-h height] [-f offset] [-t text] [-d true]");
            System.exit(-1);
        }
        if (out == null) {
            out = new File(in).getAbsoluteFile().getParentFile();
        }
        if (out.isDirectory()) {
            out = new File(out, new File(in).getName().replaceAll("[.][^.]+$", "") + ".ledfont");
        }
        if (in.toLowerCase().endsWith(".py")) {
            FontConverter.convertFromPython(new File(in), height, out);
        } else {
            Font font = FontConverter.loadTTF(in);
            font = font.deriveFont(font.getStyle(), points);
            FontConverter.convert(font, height, offset, out);
        }
        if (text != null || dump) {
            LEDFont ledfont = new LEDFont(out.getAbsolutePath());
            if (dump) {
                text = ledfont.getSupportedCharsAsString();
            }
            System.out.println(ledfont.toAsciiArt(text, 80));
        }
    }
}

