/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.Closeable;
import java.io.IOException;
import net.freeutils.scrollphat.JNADevDevice;
import net.freeutils.scrollphat.MockDevice;
import net.freeutils.scrollphat.Pi4JDevice;

public abstract class Device
implements Closeable {
    public static final int ADDR_GND = 96;
    public static final int ADDR_SCL = 97;
    public static final int ADDR_SDA = 98;
    public static final int ADDR_VCC = 99;
    public static final byte REG_CONFIG = 0;
    public static final byte REG_MATRIX1_DATA_START = 1;
    public static final byte REG_MATRIX2_DATA_START = 14;
    public static final byte REG_UPDATE = 12;
    public static final byte REG_BRIGHTNESS_CONFIG = 13;
    public static final byte REG_BRIGHTNESS_PWM = 25;
    public static final byte REG_RESET = -1;
    public static final byte CONFIG_MATRIX_8X8 = 0;
    public static final byte CONFIG_MATRIX_7X9 = 1;
    public static final byte CONFIG_MATRIX_6X10 = 2;
    public static final byte CONFIG_MATRIX_5X11 = 3;
    public static final byte CONFIG_AUDIO_INPUT = 4;
    public static final byte CONFIG_DISPLAY_MATRIX_1 = 0;
    public static final byte CONFIG_DISPLAY_MATRIX_2 = 8;
    public static final byte CONFIG_DISPLAY_MATRIX_1_AND_2 = 24;
    public static final byte CONFIG_SOFTWARE_SHUTDOWN = -128;
    protected int errors;
    protected int warnErrorCount = 10;
    protected int throwErrorCount = 1000;
    protected int width;
    protected int height;
    protected Thread shutdownHook;

    public static Device newInstance() {
        return Device.newInstance(null);
    }

    public static Device newInstance(String impl) {
        if (impl == null) {
            impl = System.getProperty("scrollphat.impl", "pi4j");
        }
        if ((impl = impl.toLowerCase()).equals("pi4j")) {
            return new Pi4JDevice();
        }
        if (impl.equals("jnadev")) {
            return new JNADevDevice();
        }
        if (impl.equals("mock")) {
            return new MockDevice();
        }
        throw new IllegalArgumentException("unknown device implementation: " + impl);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void handleError(IOException ioe) throws IOException {
        ++this.errors;
        if (this.warnErrorCount > 0 && this.errors % this.warnErrorCount == 0) {
            System.err.println("warning: accumulated " + this.errors + " errors, check your connections (last error: " + ioe + ")");
        }
        if (this.throwErrorCount > 0 && this.errors % this.throwErrorCount == 0) {
            throw ioe;
        }
    }

    public Device open(int address) throws IOException {
        return this.open(1, address);
    }

    public Device open(int busNumber, int address) throws IOException {
        if (busNumber < 0) {
            throw new IllegalArgumentException("invalid bus number: " + busNumber);
        }
        if (address < 96 || address > 99) {
            throw new IllegalArgumentException("invalid address: " + address);
        }
        return this.openImpl(busNumber, address);
    }

    protected abstract Device openImpl(int var1, int var2) throws IOException;

    public void close() throws IOException {
        this.closeImpl();
    }

    protected abstract void closeImpl() throws IOException;

    public void write(byte register, int data) throws IOException {
        try {
            this.writeImpl(register, data);
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
    }

    protected void writeImpl(byte register, int data) throws IOException {
        this.write(register, new byte[]{(byte)data}, 0, 1);
    }

    public void write(byte register, byte[] data, int offset, int length) throws IOException {
        try {
            this.writeImpl(register, data, offset, length);
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
    }

    protected abstract void writeImpl(byte var1, byte[] var2, int var3, int var4) throws IOException;

    public Device closeOnShutdown(boolean enable) {
        if (enable && this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                public void run() {
                    try {
                        Device.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else if (!enable && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        return this;
    }

    public Device configure(int config) throws IOException {
        this.reset();
        if ((config & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("invalid config bitmask: " + config);
        }
        this.write((byte)0, config);
        this.width = 8 + (config & 3);
        this.height = 16 - this.width;
        return this;
    }

    public Device init() throws IOException {
        this.closeOnShutdown(true);
        return this.open(96).configure(3);
    }

    public void reset() throws IOException {
        this.write((byte)-1, 0);
    }

    public void setBrightness(int value) throws IOException {
        this.write((byte)25, value);
    }

    public void update() throws IOException {
        this.write((byte)12, 0);
    }

    public void update(byte[] columns) throws IOException {
        this.setDisplay(columns);
        this.update();
    }

    public void setDisplay(int column, int value) throws IOException {
        if (column < 0 || column >= this.width) {
            throw new IndexOutOfBoundsException("column " + column);
        }
        this.write((byte)(1 + column), value);
    }

    public void setDisplay(int startColumn, byte[] columns, int offset, int length) throws IOException {
        if (startColumn < 0) {
            offset -= startColumn;
            length += startColumn;
            startColumn = 0;
        }
        if ((length = Math.min(length, Math.min(this.width - startColumn, columns.length - offset))) > 0) {
            this.write((byte)(1 + startColumn), columns, offset, length);
        }
    }

    public void setDisplay(int startColumn, byte[] columns) throws IOException {
        this.setDisplay(startColumn, columns, 0, this.width);
    }

    public void setDisplay(byte[] columns) throws IOException {
        this.setDisplay(0, columns, 0, this.width);
    }

    public void displayTestPatterns() throws IOException, InterruptedException {
        int width = this.getWidth();
        byte[] matrix = new byte[width];
        for (int round = 0; round < 4; ++round) {
            this.setBrightness(1);
            for (int i = 0; i < 2 * width; ++i) {
                if (i == width) {
                    int levels = 60;
                    for (int j = 0; j < levels; ++j) {
                        this.setBrightness(1 + 20 * Math.min(j, levels - j) / levels);
                        Thread.sleep(800 / levels);
                    }
                }
                matrix[i % width] = i < width ? -1 : 0;
                this.update(matrix);
                Thread.sleep(800 / width);
            }
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Device.newInstance().init().displayTestPatterns();
    }
}

