/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.IOException;
import java.util.Arrays;

public class Canvas {
    byte[] matrix;
    byte[] buffer;
    int width;
    int height;
    int offset;
    boolean flip;
    boolean reverse;

    public static String toAsciiArt(byte[] matrix, int offset, int len, int height) {
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder((len + 2) * height);
        for (int row = 0; row < height; ++row) {
            int end = offset + len;
            for (int col = offset; col < end; ++col) {
                boolean bit = (matrix[col] >> row & 1) == 1;
                sb.append(bit ? (char)'\u2593' : '\u2591');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String toAsciiArt(byte[] matrix, int height) {
        return Canvas.toAsciiArt(matrix, 0, matrix.length, height);
    }

    public static byte flip(byte b) {
        b = (byte)((b & 0xF0) >>> 4 | (b & 0xF) << 4);
        b = (byte)((b & 0xCC) >>> 2 | (b & 0x33) << 2);
        b = (byte)((b & 0xAA) >>> 1 | (b & 0x55) << 1);
        return b;
    }

    public static byte flip(byte b, int height) {
        return (byte)((Canvas.flip(b) & 0xFF) >>> 8 - height);
    }

    public static byte[] flip(byte[] matrix, int height, byte[] out) {
        int len = matrix.length;
        if (len != out.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        for (int i = 0; i < len; ++i) {
            out[i] = Canvas.flip(matrix[i], height);
        }
        return out;
    }

    public static byte[] reverse(byte[] matrix, byte[] out) {
        int len = matrix.length;
        if (len != out.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        if (matrix != out) {
            for (int i = 0; i < len; ++i) {
                out[i] = matrix[len - 1 - i];
            }
        } else {
            System.arraycopy(matrix, 0, out, 0, len);
            len >>= 1;
            int i = 0;
            int j = out.length - 1;
            while (i < len) {
                byte temp = out[i];
                out[i] = out[j];
                out[j] = temp;
                ++i;
                --j;
            }
        }
        return out;
    }

    public static byte[] cropX(byte[] matrix, int x, int width, byte[] out) {
        int i;
        int dest = 0;
        if (x < 0) {
            dest = -x;
            width += x;
            x = 0;
        }
        width = Math.min(width, Math.max(0, matrix.length - x));
        int len = out.length;
        if (dest < len && width > 0) {
            System.arraycopy(matrix, x, out, dest, width);
        }
        for (i = 0; i < dest && i < len; ++i) {
            out[i] = 0;
        }
        for (i = dest + width; i < len; ++i) {
            out[i] = 0;
        }
        return out;
    }

    public static byte[] cropY(byte[] matrix, int y, int height, byte[] out) {
        int mask = (1 << height) - 1;
        int len = matrix.length;
        if (y >= 0) {
            for (int i = 0; i < len; ++i) {
                out[i] = (byte)((matrix[i] & 0xFF) >>> y & mask);
            }
        } else {
            y = -y;
            for (int i = 0; i < len; ++i) {
                out[i] = (byte)(matrix[i] << y & mask);
            }
        }
        return out;
    }

    public static byte[] crop(byte[] matrix, int x, int y, int width, int height, byte[] out) {
        return Canvas.cropY(Canvas.cropX(matrix, x, width, out), y, height, out);
    }

    public static byte[] empty(byte[] matrix) {
        return Canvas.fill(matrix, 0);
    }

    public static byte[] fill(byte[] matrix, int value) {
        Arrays.fill(matrix, (byte)value);
        return matrix;
    }

    public static byte[] fill(byte[] matrix) {
        return Canvas.fill(matrix, 255);
    }

    public static void setBit(byte[] matrix, int x, int y, boolean value) {
        if (value) {
            int n = x;
            matrix[n] = (byte)(matrix[n] | 1 << y);
        } else {
            int n = x;
            matrix[n] = (byte)(matrix[n] & ~(1 << y));
        }
    }

    public static void graph(byte[] matrix, int width, int height, float[] values, Float low, Float high, boolean bars) {
        int len = values.length;
        if (len > width) {
            throw new IllegalArgumentException("too many values (max " + width + ")");
        }
        if (len == 0) {
            return;
        }
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (float value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        if (low != null) {
            min = low.floatValue();
        }
        if (high != null) {
            max = high.floatValue();
        }
        float range = max - min;
        for (int i = 0; i < width; ++i) {
            int val;
            int n = val = i < len ? (int)((int)Math.ceil((values[i] - min) / range * (float)height)) : 0;
            val = val <= 0 ? 0 : (bars ? (int)((byte)((1 << height) - 1 & ~((1 << height - (val > height ? height : val)) - 1))) : (int)((byte)(1 << height - val)));
            matrix[i] = val;
        }
    }

    public static void graph(byte[] matrix, int width, int height, int[] values, Float low, Float high, boolean bars) {
        float[] floats = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            floats[i] = values[i];
        }
        Canvas.graph(matrix, width, height, floats, low, high, bars);
    }

    public Canvas(byte[] matrix, int height) throws IOException {
        this.height = height;
        this.setMatrix(matrix);
    }

    public Canvas(int width, int height) throws IOException {
        this(new byte[width], height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setFlip(boolean flip) {
        this.flip = flip;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public byte[] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(byte[] matrix) {
        this.matrix = matrix;
        this.width = matrix.length;
        this.buffer = new byte[matrix.length];
    }

    public void setColumn(int column, int value) {
        this.matrix[column] = (byte)value;
    }

    public void setColumns(int startColumn, byte[] columns, int offset, int length) {
        System.arraycopy(columns, offset, this.matrix, startColumn, length);
    }

    public void setPixel(int x, int y, boolean value) {
        Canvas.setBit(this.matrix, x, y, value);
    }

    public void fill(int value) {
        Canvas.fill(this.matrix, value);
    }

    public void empty() throws IOException {
        this.fill(0);
        this.offset = 0;
    }

    public byte[] render() throws IOException {
        byte[] b = this.matrix;
        int offset = this.offset;
        if (this.flip) {
            b = Canvas.flip(b, this.height, this.buffer);
        }
        if (this.reverse) {
            offset = b.length - offset;
            b = Canvas.reverse(b, this.buffer);
        }
        this.buffer = Canvas.cropX(b, offset, this.width, this.buffer);
        return this.buffer;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void scroll(int delta) {
        this.setOffset(this.offset + delta);
    }

    public void graph(int[] values, Float low, Float high, boolean bars) {
        Canvas.graph(this.matrix, this.getWidth(), this.getHeight(), values, low, high, bars);
    }
}

