/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.scrollphat;

import java.io.IOException;
import net.freeutils.scrollphat.Canvas;
import net.freeutils.scrollphat.Device;

public class Animation {
    public static void gradualBrightness(Device device, int startValue, int endValue, int duration) throws IOException, InterruptedException {
        int steps = Math.abs(endValue - startValue);
        int interval = steps == 0 || duration <= 0 ? 1 : duration / steps;
        for (int i = startValue; i < endValue; ++i) {
            device.setBrightness(i);
            Thread.sleep(interval);
        }
        device.setBrightness(endValue);
    }

    public static void scroll(Device device, byte[] matrix, int interval, int iterations, int spaceBefore, int spaceAfter) throws InterruptedException, IOException {
        int width = device.getWidth();
        spaceAfter = Math.max(spaceAfter, 0);
        spaceBefore = Math.max(spaceBefore, 0);
        int len = matrix.length - width + 1 + spaceBefore + spaceAfter;
        int count = iterations * len;
        Canvas canvas = new Canvas(matrix, device.getHeight());
        for (int i = 0; i < count || iterations < 0; ++i) {
            if (i % len == 0) {
                canvas.setOffset(-spaceBefore);
            }
            device.update(canvas.render());
            if (interval > 0) {
                Thread.sleep(interval);
            }
            canvas.scroll(1);
        }
    }

    public static void scroll(Device device, byte[] matrix, int interval, int iterations) throws InterruptedException, IOException {
        int width = device.getWidth();
        Animation.scroll(device, matrix, interval, iterations, width, width);
    }

    public static void transitionHorizontally(Device device, byte[] matrix1, byte[] matrix2, int interval) throws IOException, InterruptedException {
        int width = device.getWidth();
        Canvas canvas = new Canvas(2 * width, device.getHeight());
        canvas.setColumns(0, matrix1, Math.max(0, matrix1.length - width), Math.min(width, matrix1.length));
        canvas.setColumns(width, matrix2, 0, Math.min(width, matrix2.length));
        Animation.scroll(device, canvas.getMatrix(), interval, 1, 0, 0);
    }

    public static void transitionVertically(Device device, byte[] matrix1, byte[] matrix2, int interval) throws IOException, InterruptedException {
        int height = device.getHeight();
        int width = device.getWidth();
        byte[] buf = new byte[width];
        for (int i = 0; i <= height; ++i) {
            for (int j = 0; j < width; ++j) {
                buf[j] = 0;
                if (j < matrix1.length) {
                    int n = j;
                    buf[n] = (byte)(buf[n] | matrix1[j] >>> i);
                }
                if (j >= matrix2.length) continue;
                int n = j;
                buf[n] = (byte)(buf[n] | matrix2[j] << height - i);
            }
            device.update(buf);
            Thread.sleep(interval);
        }
    }
}

