/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.util;

import java.util.HashMap;
import java.util.Map;
import net.fortytwo.linkeddata.sail.LinkedDataSail;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPUtils {
    private static final Logger logger = LoggerFactory.getLogger(HTTPUtils.class);
    public static final String ACCEPT = "Accept";
    public static final String BODY = "Body";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String SPARQL_QUERY = "application/sparql-query";
    public static final String USER_AGENT = "User-Agent";
    private static final Map<String, Long> lastRequestByHost = new HashMap<String, Long>();
    private static final long COURTESY_INTERVAL;
    private static final long CONNECTION_TIMEOUT;

    public static HttpClient createClient(boolean autoRedirect) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout((int)CONNECTION_TIMEOUT).setConnectTimeout((int)CONNECTION_TIMEOUT).setConnectionRequestTimeout((int)CONNECTION_TIMEOUT).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).disableContentCompression();
        if (!autoRedirect) {
            builder = builder.disableRedirectHandling();
        }
        return builder.build();
    }

    public static HttpGet createGetMethod(String url) {
        HttpGet method = new HttpGet(url);
        HTTPUtils.setAgent((HttpRequest)method);
        return method;
    }

    public static void setAcceptHeader(HttpRequest method, String value) {
        method.setHeader(ACCEPT, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long throttleHttpRequest(HttpRequest method) {
        String uri = method.getRequestLine().getUri();
        if (null == uri || 0 == uri.length() || !uri.startsWith("http://") && !uri.startsWith("https://")) {
            return 0L;
        }
        String host = uri.substring(uri.indexOf("//") + 2);
        int i = host.indexOf("/");
        if (i > 0) {
            host = host.substring(0, i);
        }
        if ((i = host.indexOf("#")) > 0) {
            host = host.substring(0, i);
        }
        long now = System.currentTimeMillis();
        long w = 0L;
        Map<String, Long> map = lastRequestByHost;
        synchronized (map) {
            Long lastRequest = lastRequestByHost.get(host);
            if (null != lastRequest && now - lastRequest < COURTESY_INTERVAL) {
                w = lastRequest + COURTESY_INTERVAL - now;
            }
            lastRequestByHost.put(host, w + now);
        }
        if (w > 0L) {
            try {
                Thread.sleep(w);
            }
            catch (InterruptedException e) {
                logger.warn("interrupted while sleeping", (Throwable)e);
            }
        }
        return System.currentTimeMillis() - now;
    }

    private static void setAgent(HttpRequest method) {
        method.setHeader(USER_AGENT, "LinkedDataSail/${project.version}");
    }

    static {
        try {
            COURTESY_INTERVAL = Long.valueOf(LinkedDataSail.getProperty("net.fortytwo.linkeddata.httpConnectionCourtesyInterval", "500"));
            CONNECTION_TIMEOUT = Long.valueOf(LinkedDataSail.getProperty("net.fortytwo.linkeddata.httpConnectionTimeout", "10000"));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

