/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.sail;

import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.IRI;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailConnectionTripleSource
implements TripleSource {
    private static final Logger logger = LoggerFactory.getLogger(SailConnectionTripleSource.class);
    private final SailConnection sailConnection;
    private final ValueFactory valueFactory;
    private final boolean includeInferred;

    public SailConnectionTripleSource(SailConnection conn, ValueFactory valueFactory, boolean includeInferred) {
        this.sailConnection = conn;
        this.valueFactory = valueFactory;
        this.includeInferred = includeInferred;
    }

    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        try {
            return new QueryEvaluationIteration((CloseableIteration<? extends Statement, SailException>)this.sailConnection.getStatements(subj, pred, obj, this.includeInferred, contexts));
        }
        catch (SailException e) {
            logger.warn("query evaluation failed", (Throwable)e);
            return new EmptyCloseableIteration();
        }
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    private static class EmptyCloseableIteration<T, E extends Exception>
    implements CloseableIteration<T, E> {
        private EmptyCloseableIteration() {
        }

        public void close() throws E {
        }

        public boolean hasNext() throws E {
            return false;
        }

        public T next() throws E {
            return null;
        }

        public void remove() throws E {
        }
    }

    private static class QueryEvaluationIteration
    implements CloseableIteration<Statement, QueryEvaluationException> {
        private final CloseableIteration<? extends Statement, SailException> baseIteration;

        public QueryEvaluationIteration(CloseableIteration<? extends Statement, SailException> baseIteration) {
            this.baseIteration = baseIteration;
        }

        public void close() throws QueryEvaluationException {
            try {
                this.baseIteration.close();
            }
            catch (SailException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public boolean hasNext() throws QueryEvaluationException {
            try {
                return this.baseIteration.hasNext();
            }
            catch (SailException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public Statement next() throws QueryEvaluationException {
            try {
                return (Statement)this.baseIteration.next();
            }
            catch (SailException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }

        public void remove() throws QueryEvaluationException {
            try {
                this.baseIteration.remove();
            }
            catch (SailException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }
    }
}

