/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.sail;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.SailConnectionTripleSource;
import org.openrdf.model.IRI;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.SimpleEvaluationStrategy;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.AbstractSail;
import org.openrdf.sail.helpers.NotifyingSailConnectionBase;
import org.openrdf.sail.helpers.SailBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedDataSailConnection
extends NotifyingSailConnectionBase {
    private static final Logger logger = LoggerFactory.getLogger(LinkedDataSailConnection.class);
    private final ValueFactory valueFactory;
    private final LinkedDataCache linkedDataCache;
    private final SailConnection baseConnection;

    public synchronized void addConnectionListener(SailConnectionListener listener) {
        if (this.baseConnection instanceof NotifyingSailConnection) {
            ((NotifyingSailConnection)this.baseConnection).addConnectionListener(listener);
        }
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.baseConnection.addStatement(subj, pred, obj, contexts);
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        this.baseConnection.clear(contexts);
    }

    protected void clearNamespacesInternal() throws SailException {
        this.baseConnection.clearNamespaces();
    }

    protected synchronized void closeInternal() throws SailException {
        this.baseConnection.rollback();
        this.baseConnection.close();
    }

    protected void commitInternal() throws SailException {
        this.baseConnection.commit();
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource((SailConnection)this, this.valueFactory, includeInferred);
            SimpleEvaluationStrategy strategy = new SimpleEvaluationStrategy((TripleSource)tripleSource, dataset, null);
            return strategy.evaluate(tupleExpr, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        return this.baseConnection.getContextIDs();
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        return this.baseConnection.getNamespace(prefix);
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return this.baseConnection.getNamespaces();
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.extendClosureToStatement(subj, pred, obj, contexts);
        return this.baseConnection.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public synchronized void removeConnectionListener(SailConnectionListener listener) {
        if (this.baseConnection instanceof NotifyingSailConnection) {
            ((NotifyingSailConnection)this.baseConnection).removeConnectionListener(listener);
        }
    }

    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.baseConnection.removeNamespace(prefix);
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... context) throws SailException {
        this.baseConnection.removeStatements(subj, pred, obj, context);
    }

    protected void rollbackInternal() throws SailException {
        this.baseConnection.rollback();
    }

    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.baseConnection.setNamespace(prefix, name);
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        return this.baseConnection.size(contexts);
    }

    protected void startTransactionInternal() throws SailException {
        this.baseConnection.begin();
    }

    LinkedDataSailConnection(SailBase sail, Sail baseSail, LinkedDataCache linkedDataCache) throws SailException {
        super((AbstractSail)sail);
        this.linkedDataCache = linkedDataCache;
        this.valueFactory = baseSail.getValueFactory();
        this.baseConnection = baseSail.getConnection();
    }

    private void retrieveUri(IRI uri) {
        try {
            this.linkedDataCache.retrieve(uri, this.baseConnection);
        }
        catch (IOException e) {
            logger.error("failed to retrieve URI", (Throwable)e);
        }
    }

    private void extendClosureToStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.linkedDataCache.getDereferenceSubjects() && null != subj && subj instanceof IRI) {
            this.retrieveUri((IRI)subj);
        }
        if (this.linkedDataCache.getDereferencePredicates() && null != pred) {
            this.retrieveUri(pred);
        }
        if (this.linkedDataCache.getDereferenceObjects() && null != obj && obj instanceof IRI) {
            this.retrieveUri((IRI)obj);
        }
        if (this.linkedDataCache.getDereferenceContexts()) {
            for (Resource ctx : contexts) {
                if (null == ctx || !(ctx instanceof IRI)) continue;
                this.retrieveUri((IRI)ctx);
            }
        }
    }
}

