/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.sail;

import java.io.File;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.sail.LinkedDataSailConnection;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;
import org.openrdf.sail.helpers.SailBase;

public class LinkedDataSail
extends SailBase
implements StackableSail,
NotifyingSail {
    public static final String CACHE_LIFETIME = "net.fortytwo.linkeddata.cacheLifetime";
    public static final String DATATYPE_HANDLING_POLICY = "net.fortytwo.linkeddata.datatypeHandlingPolicy";
    public static final String MEMORY_CACHE_CAPACITY = "net.fortytwo.linkeddata.memoryCacheCapacity";
    public static final String USE_BLANK_NODES = "net.fortytwo.linkeddata.useBlankNodes";
    public static final String HTTPCONNECTION_COURTESY_INTERVAL = "net.fortytwo.linkeddata.httpConnectionCourtesyInterval";
    public static final String HTTPCONNECTION_TIMEOUT = "net.fortytwo.linkeddata.httpConnectionTimeout";
    public static final String RANDOM_URN_PREFIX = "urn:uuid:";
    private final LinkedDataCache cache;
    private Sail baseSail;

    public static String getProperty(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public LinkedDataSail(Sail baseSail, LinkedDataCache cache) {
        this.baseSail = baseSail;
        this.cache = cache;
    }

    public LinkedDataSail(Sail baseSail) {
        this(baseSail, LinkedDataCache.createDefault(baseSail));
    }

    public void addSailChangedListener(SailChangedListener listener) {
        if (this.baseSail instanceof NotifyingSail) {
            ((NotifyingSail)this.baseSail).addSailChangedListener(listener);
        }
    }

    public NotifyingSailConnection getConnection() throws SailException {
        SailConnection sc = this.getConnectionInternal();
        return (NotifyingSailConnection)sc;
    }

    protected synchronized SailConnection getConnectionInternal() throws SailException {
        return new LinkedDataSailConnection(this, this.baseSail, this.cache);
    }

    public File getDataDir() {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        return this.baseSail.getValueFactory();
    }

    public void initialize() throws SailException {
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public void removeSailChangedListener(SailChangedListener listener) {
        if (this.baseSail instanceof NotifyingSail) {
            ((NotifyingSail)this.baseSail).removeSailChangedListener(listener);
        }
    }

    public void setDataDir(File dataDir) {
        throw new UnsupportedOperationException();
    }

    protected void shutDownInternal() throws SailException {
        this.cache.close();
    }

    public Sail getBaseSail() {
        return this.baseSail;
    }

    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    public LinkedDataCache getCache() {
        return this.cache;
    }
}

