/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.rdfizers;

import java.io.IOException;
import java.io.InputStream;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.Rdfizer;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerbatimRdfizer
implements Rdfizer {
    private static final Logger logger = LoggerFactory.getLogger(VerbatimRdfizer.class);
    private final RDFFormat format;
    private final RDFParser parser;

    public VerbatimRdfizer(RDFFormat format, RDFParser.DatatypeHandling datatypeHandling) {
        this.format = format;
        this.parser = Rio.createParser((RDFFormat)format);
        this.parser.setDatatypeHandling(datatypeHandling);
    }

    @Override
    public CacheEntry.Status rdfize(InputStream is, RDFHandler handler, String baseUri) {
        try {
            this.parser.setRDFHandler(handler);
            this.parser.parse(is, baseUri);
        }
        catch (IOException e) {
            logger.warn("I/O error in " + this.format.getName() + " rdfizer", (Throwable)e);
            return CacheEntry.Status.Failure;
        }
        catch (RDFParseException e) {
            logger.warn("RDF parsing error in " + this.format.getName() + " rdfizer", (Throwable)e);
            return CacheEntry.Status.ParseError;
        }
        catch (RDFHandlerException e) {
            logger.warn("RDF handler error in " + this.format.getName() + " rdfizer", (Throwable)e);
            return CacheEntry.Status.Failure;
        }
        catch (Throwable t) {
            logger.error("unclassified error in " + this.format.getName() + " rdfizer", t);
        }
        return CacheEntry.Status.Success;
    }

    public String toString() {
        return "'" + this.format.getName() + "' verbatim rdfizer";
    }
}

